package 
{
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.filters.GlowFilter;
	import flash.geom.Vector3D;
	import flash.ui.Keyboard;
	//
	import away3d.core.base.Object3D;
	import away3d.core.utils.Cast;
	import away3d.core.render.Renderer;
	import away3d.primitives.Plane;
	import away3d.primitives.Trident;
	import away3d.materials.MovieMaterial;
	import away3d.materials.BitmapMaterial;
	import away3d.events.MouseEvent3D;
	import away3d.events.Loader3DEvent;
	import away3d.containers.ObjectContainer3D;
	import away3d.containers.View3D;
	import away3d.loaders.Loader3D;
	import away3d.loaders.Max3DS;
	//
	import com.greensock.TweenMax;
	import com.greensock.TimelineMax;
	/**
	 * ...
	 * @author 
	 */
	public class MouseEvent3DExample extends Sprite 
	{
		private var view:View3D;
		private var trident:Trident;
		private var pointer:Plane;
		private var pointerMC:Crosshair = new Crosshair();
		private var board:ObjectContainer3D;
		private var ground:Plane;
		private var texture:BitmapMaterial;
		private var modelLoader:Loader3D;
		private var landingDock:ObjectContainer3D;
		private var fighter:ObjectContainer3D;
		private var animations:TimelineMax;
		private var leftArrowDown:Boolean = false;
		private var rightArrowDown:Boolean = false;
		private var upArrowDown:Boolean = false;
		private var downArrowDown:Boolean = false;
		//
		private var selectedBuilding:Object3D;
		private var selectedVehicle:Object3D;
		private var ctrlDown:Boolean = false;
		private var zoomInDown:Boolean = false;
		private var zoomOutDown:Boolean = false;
		private var fighters:Vector.<Object3D> = new Vector.<Object3D>;
		
		public function MouseEvent3DExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			stage.quality = StageQuality.LOW;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			removeEventListener(Event.ADDED_TO_STAGE, init);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			//
			view = new View3D();
			view.renderer = Renderer.BASIC;
			view.x = 320;
			view.y = 240;
			addChild(view);
			view.camera.zoom = 15;
			view.camera.y = 800;
			view.camera.lookAt(new Vector3D(0, 0, 0));
			view.scene.addOnMouseMove(overScene);
			//
			trident = new Trident(100, true);
			//view.scene.addChild(trident);
			//
			pointer = new Plane( { width:34, height:34, material:new MovieMaterial(pointerMC),pushfront:true } );
			initBoard();
			initBuildings();
			onResize();
		}
		
		private function initBoard():void
		{
			board = new ObjectContainer3D();
			texture = new BitmapMaterial(Cast.bitmap('terrain'));
			ground = new Plane();
			ground.width = 512;
			ground.height = 512;
			ground.pushback = true;
			ground.material = texture;
			ground.addOnMouseDown(onGroundClick);
			board.addChild(ground);
			view.scene.addChild(board);
		}
		
		private function overScene(e:MouseEvent3D):void 
		{
            pointer.x = e.sceneX;
            pointer.z = e.sceneZ;
        }
		
		private function onGroundClick(e:MouseEvent3D):void
		{
			trace(e.sceneX, e.sceneZ);
			if (ctrlDown && selectedBuilding)
			{
				selectedBuilding.alpha = 1;
				selectedBuilding.x = pointer.x;
				selectedBuilding.z = pointer.z;
				selectedBuilding = null;
				view.scene.removeChild(pointer);
			}
			else if (ctrlDown && selectedVehicle)
			{
				view.scene.removeChild(pointer);
				TweenMax.to(selectedVehicle, 1, { x:pointer.x, z:pointer.z, onComplete:function() { selectedBuilding = null; } } );
			}
			else{}
		}
		
		private function initBuildings():void
		{
			modelLoader = Max3DS.load('../../resources/models/max3ds/landingDock/LandingDock.3DS');
			modelLoader.addOnSuccess(onLandingDockSuccess);
		}
		
		private function onLandingDockSuccess(e:Loader3DEvent):void
		{
			landingDock = new ObjectContainer3D();
			landingDock.ownCanvas = true;
			landingDock.name = 'RED_landingDock';
			landingDock.addChild(modelLoader.handle);
			landingDock.scale(.2);
			landingDock.x = 71;
			landingDock.z = 196;
			landingDock.y = 15;
			landingDock.rotationX = 90;
			landingDock.filters = [ new GlowFilter(0xFF0000, 0, 7, 7, 1, 1)];
			view.scene.addChild(landingDock);
			landingDock.addOnMouseDown(landingDockOnMouseDown);
			landingDock.addOnRollOver(landingDockOnMouseRollOver);
			landingDock.addOnRollOut(landingDockOnMouseRollOut);
		}
		
		private function landingDockOnMouseDown(e:MouseEvent3D):void
		{
			trace('landingDock:CLICK');
			if (ctrlDown)
			{
				selectedBuilding = landingDock;
				selectedBuilding.alpha = .5;
				view.scene.addChild(pointer);
				pointerMC.gotoAndStop('move');
			}else
			{
				modelLoader = Max3DS.load('../../resources/models/max3ds/spaceFighter01/spaceFighter01.3ds');
				modelLoader.addOnSuccess(onModelLoaderSuccess);
			}
		}
		
		private function landingDockOnMouseRollOver(e:MouseEvent3D):void
		{
			trace('landingDock:RollOver');
			TweenMax.to(landingDock.filters[0], .5, { alpha:1 } );
		}
		
		private function landingDockOnMouseRollOut(e:MouseEvent3D):void
		{
			trace('landingDock:RollOut');
			TweenMax.to(landingDock.filters[0], .5, { alpha:0 } );
		}
			
		private function randomPosition(min:Number, max:Number):Number
		{
			return Math.floor(Math.random() * (1 + max - min)) + min;
		}
		 
		private function onModelLoaderSuccess(e:Loader3DEvent):void
		{
			var randomX:Number = landingDock.x - randomPosition( -150, 150); 
			var randomZ:Number = landingDock.z - randomPosition( -150, 150);
			fighter = new ObjectContainer3D();
			fighter.ownCanvas = true;
			fighter.addOnMouseDown(fighterOnMouseDown);
			fighter.addOnRollOver(fighterOnMouseRollOver);
			fighter.addOnRollOut(fighterOnMouseRollOut);
			fighter.name = fighter + fighters.length;
			fighter.filters = [new GlowFilter(0xFF0000, 0, 7, 7, 1, 1)];
			fighter.addChild(modelLoader.handle);
			fighter.scale(.001);
			fighter.rotationX = 90;
			fighter.x = landingDock.x;
			fighter.y = 20;
			fighter.z = landingDock.z;
			view.scene.addChild(fighter);
			fighters.push(fighter);
			animations = new TimelineMax( { onComplete:onFighterReady } );
			animations.append(TweenMax.to(fighter, 1, { scaleX:.1, scaleY:.1, scaleZ:.1 } ));
			animations.append(TweenMax.to(fighter, 2, { x:randomX, y: 60, z:randomZ } ));
			animations.play();
		}
		
		private function onFighterReady():void
		{
			trace('Fighter ready!');
		}
		
		private function fighterOnMouseDown(e:MouseEvent3D):void
		{
			trace('Fighter:CLICK');
			if (ctrlDown)
			{
				selectedVehicle = e.target as ObjectContainer3D;
				view.scene.addChild(pointer);
				pointerMC.gotoAndStop('move');
			}
		}
		
		private function fighterOnMouseRollOver(e:MouseEvent3D):void
		{
			trace('Fighter:RollOver');
			TweenMax.to(e.currentTarget.filters[0], .5, { alpha:1 } );
		}
		
		private function fighterOnMouseRollOut(e:MouseEvent3D):void
		{
			trace('Fighter:RollOut');
			TweenMax.to(e.currentTarget.filters[0], .5, { alpha:0 } );
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;
		}
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			if (e.keyCode == Keyboard.LEFT)     leftArrowDown = true;
			if (e.keyCode == Keyboard.RIGHT)    rightArrowDown = true;
			if (e.keyCode == Keyboard.UP)       upArrowDown = true;
			if (e.keyCode == Keyboard.DOWN)     downArrowDown = true;
			if (e.keyCode == Keyboard.CONTROL)  ctrlDown = true;
			if (e.keyCode == 187)  zoomInDown = true;
			if (e.keyCode == 189)  zoomOutDown = true;
		}
		
		private function onKeyUp(e:KeyboardEvent):void
		{
			if (e.keyCode == 187)  zoomInDown = false;
			if (e.keyCode == 189)  zoomOutDown = false;
			if (e.keyCode == Keyboard.LEFT)  leftArrowDown = false;
			if (e.keyCode == Keyboard.RIGHT) rightArrowDown = false;
			if (e.keyCode == Keyboard.UP)    upArrowDown = false;
			if (e.keyCode == Keyboard.DOWN)  downArrowDown = false;
			if (e.keyCode == Keyboard.CONTROL)  
			{
				ctrlDown = false;
				if (selectedBuilding)
				{
					selectedBuilding.alpha = 1;
					selectedBuilding = null;
					view.scene.removeChild(pointer);
				}
			}
		}
		
		private function onEnterFrame(e:Event):void
		{
			if (zoomInDown)
			{
				if (ctrlDown) view.camera.y += 5;
				else view.camera.zoom++;
			}
			if (zoomOutDown)
			{
				if (ctrlDown) view.camera.y -= 5;
				else view.camera.zoom--;
			}
			if (leftArrowDown)
			{
				if (ctrlDown) view.camera.rotationY++;
				else view.camera.x -= 10;
			}
			if (rightArrowDown) 
			{
				if (ctrlDown) view.camera.rotationY--;
				else view.camera.x += 10;
			}
			if (upArrowDown)
			{
				if (ctrlDown) view.camera.rotationX++;
				else view.camera.z += 10;
			}
			if (downArrowDown)
			{
				if (ctrlDown) view.camera.rotationX--;
				else view.camera.z -= 10;
			}
			view.render();
		}
	}
}