package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Vector3D;
	//
	import away3d.containers.View3D;
	import away3d.core.utils.Cast;
	import away3d.core.geom.Path;
	import away3d.extrusions.PathExtrusion;
	import away3d.materials.BitmapMaterial;
	//
	import com.greensock.TweenMax;
	/**
	 * ...
	 * @author 
	 */
	public class PathExtrusionExample extends Sprite 
	{
		private var view:View3D;
		private var path:Path;
		private var profile:Array;
		private var track:PathExtrusion;
		private var texture:BitmapMaterial;
		public function PathExtrusionExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			//
			view = new View3D();
			view.x = 320;
			view.y = 240;
			addChild(view);
			view.camera.y = 1000;
			view.camera.z = -1500;
			view.camera.lookAt(new Vector3D(0, 0, 0));
			//
			path =  new Path(
			[
				new Vector3D( -400, 0, 0),
				new Vector3D( -400, 0, -700),
				new Vector3D(0, 0, 0),
				new Vector3D(0, 0, 0),
				new Vector3D( 400, 0, 400),
				new Vector3D( 400, 0, 0),
				new Vector3D( 400, 0, 0),
				new Vector3D( 200, 0, -700),
				new Vector3D(0, -50, 0),
				new Vector3D(0, -50, 0),
				new Vector3D( -200, 0, 700),
				new Vector3D( -400, 0, 0)
			]);
			//
			profile = new Array(
			new Vector3D(-40, 0, 0),
			new Vector3D(40, 0, 0)
			);
			//
			texture = new BitmapMaterial(Cast.bitmap('road.jpg'));
			texture.smooth = true;
			track = new PathExtrusion();
			track.path = path;
			track.profile = profile;
			track.material = texture;
			track.bothsides = true;
			track.subdivision = 20;
			track.closePath = true;
			view.scene.addChild(track);
		}
		
		private function onEnterFrame(e:Event):void
		{
			track.rotationY++;
			view.render();
		}
	}
}