package 
{
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Vector3D;
	//
	import away3d.containers.View3D;
	import away3d.containers.ObjectContainer3D;
	import away3d.core.base.Object3D;
	import away3d.core.utils.Cast;
	import away3d.materials.BitmapMaterial;
	import away3d.primitives.Sphere;
	import away3d.tools.Explode;
	//
	import com.greensock.TweenMax;
	/**
	 * ...
	 * @author 
	 */
	public class ExplosionExample extends Sprite 
	{
		private var view:View3D;
		private var deathstar:Sphere;
		private var explodedDeathstar:ObjectContainer3D;
		private var explode:Explode;
		private var partsStartPositions:Array = [];
		
		public function ExplosionExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			removeEventListener(Event.ADDED_TO_STAGE, init);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			//
			view = new View3D();
			addChild(view);
			
			deathstar = new Sphere( { segmentsH:16, segmentsW:16, radius:180, material:new BitmapMaterial(Cast.bitmap('deathstar')) } );
			explode = new Explode(true);
			explodedDeathstar = explode.apply(deathstar) as ObjectContainer3D;
			view.scene.addChild(explodedDeathstar);
			destroyDeathstar();
			onResize();
		}
		
		private function destroyDeathstar():void
		{
			for (var i:uint = 0; i < explodedDeathstar.children.length; i++)
			{
				TweenMax.to(explodedDeathstar.children[i], 10,
				{
					x:randomPosition(1000, 2000),
					y:randomPosition(1000, 2000),
					z:randomPosition(1000, 2000),
					onComplete:removePart,
					onCompleteParams:[explodedDeathstar.children[i]]
				});
			}
		}
		
		private function removePart(part:Object3D):void
		{
			explodedDeathstar.removeChild(part);
		}
		
		private function randomPosition(min:Number, max:Number):Number
		{
			return Math.floor(Math.random() * max - min);
		}
		
		private function onEnterFrame(e:Event):void
		{
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = universe.x = stage.stageWidth * .5;
			view.y = universe.y = stage.stageHeight * .5;			
		}
	}
}