package 
{
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.MouseEvent;
	import flash.geom.Vector3D;
	import flash.net.FileReference
	import flash.net.FileFilter;
	
	import away3d.containers.View3D;
	import away3d.containers.ObjectContainer3D;
	import away3d.materials.BitmapMaterial;
	import away3d.materials.WireColorMaterial;
	import away3d.materials.WireframeMaterial;
	import away3d.core.base.Mesh;
	import away3d.core.utils.Cast;
	import away3d.core.base.Object3D;
	import away3d.loaders.data.AnimationData;
	import away3d.loaders.*;
	import away3d.events.Loader3DEvent;
	
	public class ModelsExample extends Sprite 
	{
		private var panel:ModelsPanel;
		private var view:View3D;
		private var model:ObjectContainer3D;
		private var mat:BitmapMaterial;
		private var modelReference:FileReference;
		private var textureReference:FileReference;
		private var autoTexture:Boolean = true;
		private var animations:AnimationData;
		
		public function ModelsExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.addEventListener(Event.RESIZE, onResize);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			view = new View3D();
			addChild(view);
			
			addPanel();
			onResize();
		}
		
		private function addPanel():void
		{
			panel = new ModelsPanel();
			addChild(panel);
			panel.addEventListener('modelSelectEvent', onPanelEvent);
			panel.addEventListener('selectTextureEvent', onPanelEvent);
			panel.addEventListener('loadModelEvent', onPanelEvent);
			panel.addEventListener('playAnimationEvent', onPanelEvent);
			panel.addEventListener('scaleLessEvent', onPanelEvent);
			panel.addEventListener('scaleMoreEvent', onPanelEvent);
			panel.addEventListener('WireframeMaterialEvent', onPanelEvent);
			panel.addEventListener('WireColorMaterialEvent', onPanelEvent);
			panel.addEventListener('BitmapMaterialEvent', onPanelEvent);
		}
		
		private function onPanelEvent(e:Event):void
		{
			var mesh:Mesh;
			switch(e.type)
			{
				case 'modelSelectEvent':
				{
					if (model && model.children.length > 0) 
					{
						for each (var child:Mesh in model.children)
						{
							model.removeChild(child);
						}
					}
					mat = null;
					panel.setAvailability('selectTexture', false);
					panel.setAvailability('loadModel', false);
					panel.setAvailability('materialSelect', false);
					panel.setAvailability('playAnimation', false);
					panel.setAvailability('scaleMore', false);
					panel.setAvailability('scaleLess', false);
					
					modelReference = new FileReference();
					modelReference.addEventListener(Event.SELECT, onModelSelected);
					modelReference.browse(
					[
						new FileFilter('3DS Max (*.3ds)', '*.3ds'),
						new FileFilter('Wavefront (*.obj)', '*.obj'),
						new FileFilter('3DS Max ASCII (*.ase)', '*.ase'),
						new FileFilter('Away3D (*.awd)', '*.awd'),
						new FileFilter('Google Earth (*.kmz)', '*.kmz'),
						new FileFilter('Collada (*.dae)', '*.dae'),
						new FileFilter('Quake 2 (*.md2)', '*.md2')
					]);
					break;
				}
				case 'selectTextureEvent':
				{
					textureReference = new FileReference();
					textureReference.addEventListener(Event.SELECT, onTextureSelected);
					textureReference.browse(
					[
						new FileFilter('*.jpg', '*.jpg'),
						new FileFilter('*.bmp', '*.bmp'),
						new FileFilter('*.png', '*.png'),
						new FileFilter('*.tga', '*.tga')
					]);
					break;
				}
				case 'loadModelEvent':
				{
					modelReference.addEventListener(Event.COMPLETE, onModelLoaded);
					modelReference.addEventListener(IOErrorEvent.IO_ERROR, onLoadError);
					modelReference.load();
					break;
				}
				case 'playAnimationEvent':
				{
					if (animations && animations.animator.isPlaying) 
					{
						panel.setLabel('playAnimation','Włącz animacje');
						animations.animator.gotoAndStop(0);
					}
					else
					{
						animations = (modelReference.type.toLowerCase() == '.dae') ? model.animationLibrary.getAnimation('default') : model.children[0].animationLibrary.getAnimation('default');
						if (animations) 
						{
							panel.setLabel('playAnimation','Wyłącz animacje');
							animations.animator.play();
						}
					}
					break;
				}
				case 'scaleLessEvent':
				{
					if (model.scaleX > 1)
					{
						model.scaleX--;
						model.scaleY--;
						model.scaleZ--;
					}
					break;
				}
				case 'scaleMoreEvent':
				{
					model.scaleX++;
					model.scaleY++;
					model.scaleZ++;
					break;
				}
				case 'WireframeMaterialEvent':
				{
					for each(mesh in model.children)
					{
						mesh.material = new WireframeMaterial(0x000000);
					}
					break;
				}
				case 'WireColorMaterialEvent':
				{
					for each(mesh in model.children)
					{
						mesh.material = new WireColorMaterial(0xFF0000, { wireColor:0x000000 } );
					}
					break;
				}
				case 'BitmapMaterialEvent':
				{
					for each(mesh in model.children)
					{
						mesh.material = mat;
					}
					break;
				}
				default:break;
			}
		}
		
		public function onModelSelected(e:Event):void
		{
			autoTexture = true;
			panel.setAvailability('selectTexture', true);
			panel.setAvailability('loadModel', true);
		}
		
		public function onTextureSelected(e:Event):void
		{
			autoTexture = false;
			textureReference.addEventListener(Event.COMPLETE, onTextureLoaded);
			textureReference.addEventListener(IOErrorEvent.IO_ERROR, onLoadError);
			textureReference.load();
		}
		
		private function onLoadError(e:IOErrorEvent):void
		{
			trace(e);
		}
		
		private function onModelLoaded(e:Event):void
		{
			switch(modelReference.type.toLowerCase())
			{
				case '.3ds':
				model = Max3DS.parse(modelReference.data, { autoLoadTextures:(autoTexture ? true : false) } ) as ObjectContainer3D;
				break;
				case '.obj':
				model = Obj.parse(modelReference.data, { autoLoadTextures:(autoTexture ? true : false) } ) as ObjectContainer3D;
				break;
				case '.ase':
				var ase:Mesh = Ase.parse(modelReference.data, { scale:.01 } );
				model = new ObjectContainer3D();
				model.addChild(ase);
				break;
				case '.awd':
				var awd:Mesh = AWData.parse(modelReference.data) as Mesh;
				model = new ObjectContainer3D();
				model.addChild(awd); 
				break;
				case '.kmz':
				var kmz:Mesh = Kmz.parse(modelReference.data) as Mesh;
				model = new ObjectContainer3D();
				model.addChild(kmz); 
				break;
				case '.dae':
				model = Collada.parse(modelReference.data, { autoLoadTextures:(autoTexture ? true : false) } );
				panel.setAvailability('playAnimation', true);
				break;
				case '.md2':
				var md2:Mesh = Md2.parse(modelReference.data, { scale:0.01 } );
				model = new ObjectContainer3D();
				model.addChild(md2);
				panel.setAvailability('playAnimation', true);
				break;
			}
			
			panel.setAvailability('selectTexture', false);
			panel.setAvailability('loadModel', false);
			panel.setAvailability('materialSelect', true);
			panel.setAvailability('scaleMore', true);
			panel.setAvailability('scaleLess', true);
			
			if (!autoTexture)
			{
				for each(var mesh:Mesh in model.children)
				{
					mesh.material = mat;
				}
			}
			view.scene.addChild(model);
		}
		
		private function onTextureLoaded(e:Event):void
		{
			var imgLoader:Loader = new Loader();
			imgLoader.loadBytes(textureReference.data);
			imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, imgBytesLoaded);
		}
		
		private function imgBytesLoaded(e:Event):void
		{
			mat = new BitmapMaterial(Bitmap(e.target.content).bitmapData);
		}
		
		private function onResize(e:Event = null):void
		{
			panel.draw(200, stage.stageHeight);
			view.x = panel.width + (stage.stageWidth - panel.width) *.5;
			view.y = stage.stageHeight * .5;
		}
		
		private function onEnterFrame(e:Event):void
		{
			if (model) 
			{
				model.rotationY--;
				view.render();
			}
		}
	}
}