package
{
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Vector3D;
	
	import away3d.containers.View3D;
	import away3d.core.filter.*;
	import away3d.core.render.*;
	import away3d.materials.*;
	import away3d.containers.ObjectContainer3D;
	import away3d.primitives.Sphere;
	
	public class FiltersExample extends Sprite
	{
		private var view:View3D;
		private var sphs:Array = [];
		
		public function FiltersExample()
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			view = new View3D();			
			addChild(view);
			initFilter();
			fillScene();
			onResize();
		}
		
		private function initFilter():void
		{
			var maxpoly:MaxPolyFilter = new MaxPolyFilter(1000);
			view.renderer = new BasicRenderer(maxpoly);
		}
		
		private function fillScene():void
		{
			for (var i:Number = 0; i < 30; i++)
			{
				var sph:Sphere = new Sphere( { radius:50, segmentsW:16, segmentsH:16} );
				sph.x = -stage.stageWidth * .5 + (Math.random() * stage.stageWidth);
				sph.y = -stage.stageHeight * .5 + (Math.random() * stage.stageHeight);
				sph.z = -(Math.random() * 8000);
				view.scene.addChild(sph);
				sphs.push(sph);
			}
		}
		
		private function onEnterFrame(e:Event):void
		{
			for each (var sph:Sphere in sphs)
			{
				sph.z += 5;
				if (sph.z > 5000)
				{
					sph.z = -(Math.random() * 8000);
				}
			}
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
	}
}