﻿package
{
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	
	import away3d.core.clip.*;
	import away3d.containers.View3D;
	import away3d.materials.WireColorMaterial;
	import away3d.primitives.Plane;
	import away3d.debug.AwayStats;
	//import net.hires.debug.Stats;
	
	public class ClippingExample extends Sprite
	{
		private var view:View3D;
		private var fpp:FPP;
		private var stats:AwayStats;
		public function ClippingExample()
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			
			view = new View3D();
			view.camera.z = 0;
			addChild(view);
			
			fpp = new FPP(stage, { freeCamera:true, height:0 } );
			view.camera = fpp;
			
			var plane:Plane = new Plane(
			{
				width:512,
				height:512,
				depth:512,
				segmentsW:10,
				segmentsH:10,
				material:new WireColorMaterial(0xFF0000, { wireColor:0x000000 } )
			});
			view.scene.addChild(plane);
			onResize();
		}
		
		private function onEnterFrame(e:Event):void
		{
			fpp.updateCamera();
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
	}
}