 /*
  * Copyright 2009 (c) Guojian Miguel Wu
  * 
  * Licensed under the Apache License, Version 2.0 (the "License");
  * you may not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  * 
  * 	http://www.apache.org/licenses/LICENSE-2.0
  * 	
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * 
  * limitations under the License.
  * 
  */
package wumedia.parsers.swf {
	import flash.geom.Rectangle;	
	
	/**
	 * @author guojian@wu-media.com | guojian.wu@ogilvy.com
	 */
	public class DefineShape {
		public function DefineShape(tag:Tag) {
			var data:Data = tag.data;
			_id = data.readUnsignedShort();
			_bounds = data.readRect();
			if ( tag.type == TagTypes.DEFINE_SHAPE4 ) {
				_edgeBounds = data.readRect();
				// TODO: what do we do with these values?
				data.readUBits(5); // reversed - must be 0;
				data.readUBits(1); // UsesFillWindingRule if 1 (swf 10)
				data.readUBits(1); // UsesNonScalingStrokes
				data.readUBits(1); // UsesScalingStrokes
			} else {
				_edgeBounds = _bounds;
			}
			_shapes = new ShapeRecord(data, tag.type);
		}

		private var _id			:uint;
		private var _bounds		:Rectangle;
		private var _edgeBounds	:Rectangle;
		private var _shapes		:ShapeRecord;
		
		public function get id():uint {	return _id; 	}
		public function get bounds():Rectangle { return _bounds;	}
		public function get shapes():ShapeRecord { return _shapes; }
	}
}
