﻿package away3d.materials.shaders
{
	import away3d.arcane;
	import away3d.containers.*;
	import away3d.core.base.*;
	import away3d.core.render.*;
	import away3d.core.utils.*;	
	import away3d.lights.*;
	
	import flash.display.*;
	
	use namespace arcane;
	
	/**
	 * Shader class for ambient lighting
	 * 
	 * @see away3d.lights.AmbientLight3D
	 */
    public class AmbientShader extends AbstractShader
    {
		/** @private */
        arcane override function renderLayer(priIndex:uint, viewSourceObject:ViewSourceObject, renderer:Renderer, layer:Sprite, level:int):int
        {
        	super.renderLayer(priIndex, viewSourceObject, renderer, layer, level);
    		
    		var _tri_source_scene_ambientLights:Vector.<AmbientLight3D> = _source.scene.ambientLights;
        	for each (var ambient:AmbientLight3D in _tri_source_scene_ambientLights)
        	{
        		if (_source.scene.numLights > 1) {
					_shape = _session.getLightShape(this, level++, layer, ambient);
		        	_shape.blendMode = blendMode;
		        	_graphics = _shape.graphics;
		        } else {
		        	_graphics = layer.graphics;
		        }
	        	
				_source.session.renderTriangleBitmap(ambient.ambientBitmap, getUVData(priIndex), _screenVertices, _screenIndices, _startIndex, _endIndex, smooth, false, _graphics);
        	}
			
			if (debug)
            	_source.session.renderTriangleLine(0, 0x0000FF, 1, _screenVertices, renderer.primitiveCommands[priIndex], _screenIndices, _startIndex, _endIndex);
            
            return level;
        }
    	
		/**
		 * Creates a new <code>AmbientShader</code> object.
		 * 
		 * @param	init	[optional]	An initialisation object for specifying default instance properties.
		 */
        public function AmbientShader(init:Object = null)
        {
        	super(init);
        }
        
		/**
		 * @inheritDoc
		 */
        protected function updateFaces(source:Object3D, view:View3D):void
        {
        	view;//TODO : FDT Warning
        	notifyMaterialUpdate();
        	
        	for each (var _faceMaterialVO:FaceMaterialVO in _faceDictionary)
        		if (source == _faceMaterialVO.source)
	        		if (!_faceMaterialVO.cleared)
	        			_faceMaterialVO.clear();
        }
        
        
		/**
		 * @inheritDoc
		 */
        protected override function renderShader(priIndex:uint):void
        {
			_faceMaterialVO.invalidated = false;
			_faceMaterialVO.cleared = false;
			_faceMaterialVO.updated = true;
			
			priIndex;//TODO : FDT Warning
			var _source_scene_ambientLights:Vector.<AmbientLight3D> = _source.scene.ambientLights;
			for each (var ambient:AmbientLight3D in _source_scene_ambientLights)
	    	{
				_faceMaterialVO.bitmap.draw(ambient.ambientBitmap, null, null, blendMode);
	    	}
	    	
	    	var _source_scene_directionalLights:Vector.<DirectionalLight3D> = _source.scene.directionalLights;
	    	for each (var directional:DirectionalLight3D in _source_scene_directionalLights)
	    	{
				_faceMaterialVO.bitmap.draw(directional.ambientBitmap, null, null, blendMode);
	    	}
        }
    }
}
