﻿package away3d.materials
{
	import away3d.arcane;
	import away3d.core.base.*;
	import away3d.core.utils.*;
	import away3d.core.render.*;
	import away3d.core.vos.*;
	import away3d.materials.shaders.*;
	
	import flash.display.*;
	import flash.geom.*;
	
	use namespace arcane;
	
	/**
	 * Color material with environment shading.
	 */
	public class EnviroColorMaterial extends EnviroShader
	{
		/** @private */
        arcane override function renderTriangle(priIndex:uint, viewSourceObject:ViewSourceObject, renderer:Renderer):void
        {
			_source = viewSourceObject.source as Mesh;
			_session = renderer._session;
        	_view = renderer._view;
			
        	_startIndex = renderer.primitiveProperties[uint(priIndex*9)];
        	_endIndex = renderer.primitiveProperties[uint(priIndex*9+1)];
			_faceVO = renderer.primitiveElements[priIndex] as FaceVO;
			_generated = renderer.primitiveGenerated[priIndex];
			
			_screenVertices = viewSourceObject.screenVertices;
			_screenIndices = viewSourceObject.screenIndices;
			_screenUVTs = viewSourceObject.screenUVTs;
        	
			_session.renderTriangleBitmap(_colorMap, getUVData(priIndex), _screenVertices, _screenIndices, _startIndex, _endIndex, smooth, false);
            if (debug)
                _session.renderTriangleLine(thickness, wireColor, wireAlpha, _screenVertices, renderer.primitiveCommands[priIndex], _screenIndices, _startIndex, _endIndex);
        }
		/** @private */
		arcane override function renderLayer(priIndex:uint, viewSourceObject:ViewSourceObject, renderer:Renderer, layer:Sprite, level:int):int
        {
        	layer;
        	
        	_source = viewSourceObject.source as Mesh;
			_session = renderer._session;
			_view = renderer._view;
			
        	_startIndex = renderer.primitiveProperties[priIndex][uint(0)];
        	_endIndex = renderer.primitiveProperties[priIndex][uint(1)];
			_faceVO = renderer.primitiveElements[priIndex] as FaceVO;
			_generated = renderer.primitiveGenerated[priIndex];
			
			_source.session.renderTriangleBitmap(_colorMap, getUVData(priIndex), viewSourceObject.screenVertices, viewSourceObject.screenIndices, _startIndex, _endIndex, smooth, false);
			
			if (debug)
                _source.session.renderTriangleLine(0, 0x0000FF, 1, viewSourceObject.screenVertices, renderer.primitiveCommands[priIndex], viewSourceObject.screenIndices, _startIndex, _endIndex);
            
            return level;
		}
		
		private var _red:Number;
		private var _green:Number;
		private var _blue:Number;
		private var _colorMap:BitmapData;
		private var _colorTransform:ColorTransform;
		
        private function setColorTranform():void
        {
            _colorTransform = new ColorTransform(_red*_reflectiveness, _green*_reflectiveness, _blue*_reflectiveness, 1, (1-_reflectiveness)*_red*255, (1-_reflectiveness)*_green*255, (1-_reflectiveness)*_blue*255, 0);
            _colorMap = _bitmap.clone();
            _colorMap.colorTransform(_colorMap.rect, _colorTransform);
        }
        
        /**
        * Defines the color of the material.
        */
        public override function get color():uint
        {
            return _color;
        }
        
		public override function set color(val:uint):void
        {
            _color = val;
            _red = ((_color & 0xFF0000) >> 16)/255;
            _green = ((_color & 0x00FF00) >> 8)/255;
            _blue = (_color & 0x0000FF)/255;
            setColorTranform();
        }
        
		/**
		 * @inheritDoc
		 */
        public override function set reflectiveness(val:Number):void
        {
            _reflectiveness = val;
            setColorTranform();
        }
		
		/**
		 * Creates a new <code>EnviroColorMaterial</code> object.
		 * 
		 * @param	color				A string, hex value or colorname representing the color of the material.
		 * @param	enviroMap			The bitmapData object to be used as the material's environment map.
		 * @param	init	[optional]	An initialisation object for specifying default instance properties.
		 */
		public function EnviroColorMaterial(color:*, enviroMap:BitmapData, init:Object = null)
		{            
			super(enviroMap, init);
			
            this.color = Cast.trycolor(color);
		}
	}
}