﻿﻿package away3d.core.base
{
	import away3d.arcane;
	import away3d.core.geom.*;
	import away3d.core.vos.*;
	import away3d.materials.*;
	
	import flash.geom.*;
    
    use namespace arcane;
    
    /**
    * A triangle element used in the mesh object
    * 
    * @see away3d.core.base.Mesh
    */
    public class Face extends Element
    {
        private var _back:Material;
		
		//arcane var _isSplitter : Boolean;
		//prefab
		public var isBack:Boolean;
		
  		public function addUVAt(index:uint, uv:UV):void
  		{
  			if (_uvs.length <= index)
  				_uvs.length = index + 1;
  			
  			if(_uvs[index] && _uvs[index] == uv)
  				return;
            
            _uvs[index] = uv;
  			
  			uv.parents.push(this);
  			
  			if (parent) {
				uv.geometry = parent;
				parent.notifyGeometryChanged();
  			}
  		}
  		
  		public function addVertexAt(index:uint, vertex:Vertex, command:String):void
  		{
  			if (_vertices.length <= index)
  				_vertices.length = index + 1;
  			
  			if(_vertices[index] && _vertices[index] == vertex)
  				return;
  			
  			if (_vertices[index]) {
	  			var _index:int = _vertices[index].parents.indexOf(this);
	  				if(_index != -1)
	  					_vertices[index].parents.splice(_index, 1);
	  		}
	  		
			_commands[index] = command;
  			_vertices[index] = vertex;
	  		
	  		vertex._index = index;
  			
  			vertex.parents.push(this);
  			
  			if (parent) {
				vertex.geometry = parent;
				parent.notifyGeometryChanged();
  			}
  		}
  		
		public var bitmapRect:Rectangle;
		
  		public function moveTo(x:Number, y:Number, z:Number):void
  		{
  			var newVertex:Vertex = new Vertex(x, y, z);
  			addVertexAt(_vertices.length, newVertex, PathCommand.MOVE);
  			
  			_pathCommands.push(new PathCommand(PathCommand.MOVE, _lastAddedVertex.position, null, newVertex.position));
  			_lastAddedVertex = newVertex;
  		}
  		
  		public function lineTo(x:Number, y:Number, z:Number):void
  		{
  			var newVertex:Vertex = new Vertex(x, y, z);
  			addVertexAt(_vertices.length, newVertex, PathCommand.LINE);
  			
  			_pathCommands.push(new PathCommand(PathCommand.LINE, _lastAddedVertex.position, null, newVertex.position));
  			_lastAddedVertex = newVertex;
  		}
  		
  		public function curveTo(cx:Number, cy:Number, cz:Number, ex:Number, ey:Number, ez:Number):void
  		{
  			var newControlVertex:Vertex = new Vertex(cx, cy, cz);
  			var newEndVertex:Vertex = new Vertex(ex, ey, ez);
  			addVertexAt(_vertices.length, newControlVertex, PathCommand.CURVE);
  			addVertexAt(_vertices.length, newEndVertex, "P");
  			
  			_pathCommands.push(new PathCommand(PathCommand.CURVE, _lastAddedVertex.position, newControlVertex.position, newEndVertex.position));
  			_lastAddedVertex = newEndVertex;
  		}
  		
		public var faceVO:FaceVO = new FaceVO();
		
		/**
		 * Defines the material of the face.
		 */
        public override function get material():Material
        {
            return _material;
        }

        public override function set material(value:Material):void
        {
            if (value == _material)
                return;
			
			if (parent)
				parent.removeMaterial(this, _material);
            
            _material = faceVO.material = value;
            
			if (parent)
				parent.addMaterial(this, _material);
        }
		
		/**
		 * Defines the optional back material of the face.
		 * Displays when the face is pointing away from the camera.
		 */
        public function get back():Material
        {
            return _back;
        }
		
        public function set back(value:Material):void
        {
            if (value == _back)
                return;
			
			if (_back != null)
				parent.removeMaterial(this, _back);
            
            _back = faceVO.back = value;
            
			if (_back != null)
				parent.addMaterial(this, _back);
        }
		
		/**
		 * Creates a new <code>Face</code> object.
		 *
		 * @param	v0						The first vertex object of the triangle
		 * @param	v1						The second vertex object of the triangle
		 * @param	v2						The third vertex object of the triangle
		 * @param	material	[optional]	The material used by the triangle to render
		 * @param	uv0			[optional]	The first uv object of the triangle
		 * @param	uv1			[optional]	The second uv object of the triangle
		 * @param	uv2			[optional]	The third uv object of the triangle
		 * 
		 * @see	away3d.core.base.Vertex
		 * @see	away3d.materials.Material
		 * @see	away3d.core.base.UV
		 */
        public function Face(v0:Vertex = null, v1:Vertex = null, v2:Vertex = null, material:Material = null, uv0:UV = null, uv1:UV = null, uv2:UV = null)
        {
            faceVO.face = this;
			_vertices = faceVO.vertices;
			_uvs = faceVO.uvs;
			_commands = faceVO.commands;
            
        	if(v0)
            	addVertexAt(0, v0, "M");
            if(v1)
            	addVertexAt(1, v1, "L");
            if(v2)
            	addVertexAt(2, v2, "L");
            
            this.material = material;
            
            addUVAt(0, uv0 || new UV());
            addUVAt(1, uv1 || new UV());
            addUVAt(2, uv2 || new UV());
        }
		
		/**
		 * Inverts the geometry of the face object by swapping the <code>v1</code>, <code>v2</code> and <code>uv1</code>, <code>uv2</code> points.
		 */
        public function invert():void
        {
            var v1:Vertex = _vertices[uint(1)];
            var v2:Vertex = _vertices[uint(2)];
            var uv1:UV = _uvs[uint(1)];
            var uv2:UV = _uvs[uint(2)];
			
            _vertices[uint(1)] = v2;
            _vertices[uint(2)] = v1;
            _uvs[uint(1)] = uv2;
            _uvs[uint(2)] = uv1;
			
            if (parent)
            	parent.notifyGeometryChanged();
        }
        
        /**
         * Produces a clone of the face.
         * NOTE: Supports only irregular faces for now. 
         * @return [Face] The cloned face.
         * 
         */        
        public function clone():Face
        {
        	var clonedFace:Face = new Face();
        	for(var i:uint; i<_pathCommands.length; i++) {
				var command:PathCommand = _pathCommands[i];
				switch(command.type) {
					case PathCommand.MOVE:
						clonedFace.moveTo(command.pEnd.x, command.pEnd.y, command.pEnd.z);
						break;
					case PathCommand.LINE:
						clonedFace.lineTo(command.pEnd.x, command.pEnd.y, command.pEnd.z);
						break;
					case PathCommand.CURVE:
						clonedFace.curveTo(command.pControl.x, command.pControl.y, command.pControl.z, command.pEnd.x, command.pEnd.y, command.pEnd.z);
						break;
				}
			}
        	return clonedFace;
        }
    }
}
