package
{
	import away3d.containers.ObjectContainer3D;
	import away3d.core.base.Mesh;
	import away3d.materials.BitmapFileMaterial;
	import away3d.loaders.*;
	import flash.display.Stage;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	
	public class Car extends ObjectContainer3D
	{
		private var _stage:Stage;
		private var _modelLoader:Loader3D;
		private var _model:Mesh;
		private var _topSpeed:Number = 0;
		private var _topSteer:Number = 0;
		private var _speed:Number = 0;
		private var _steer:Number = 0;
		private var _scale:Number = 10;
		
		private var _leftDown:Boolean = false;
		private var _rightDown:Boolean = false;
		private var _forwardDown:Boolean = false;
		private var _backwardDown:Boolean = false;
		
		private var _maxSpeed:Number = 0;
		public static var MAX_SPEED:Number = 24;
        public static var MIN_SPEED:Number = -12;
		
		public function Car(stage:Stage) 
		{
			_stage = stage;
			_modelLoader = Obj.load('../../resources/models/mObj/car/car_riviera.obj', { autoLoadTextures:false } );
			_modelLoader.addOnSuccess(modelLoaded);
			_stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			_stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
		
		private function modelLoaded(e:Event):void
		{
			_model = _modelLoader.handle as Mesh;
			_model.y = -10;
			_model.movePivot(0, 0, 10);
			_model.material = new BitmapFileMaterial('../../resources/models/mObj/car/car_riviera.jpg');
			_model.scale(10);
			_scale = _model.scaleZ;
			addChild(_model);
		}
		
		public function update():void
		{
			if (_forwardDown) _maxSpeed = MAX_SPEED;
			else if (_backwardDown) _maxSpeed = MIN_SPEED;
            else _maxSpeed = 0;
            _speed -= (_speed - _maxSpeed) * 0.1;
			//
			if( _rightDown )
			{
				if( _topSteer < 30 )
				{
					_topSteer += 5;
				}
			}
			else if( _leftDown )
			{
				if( _topSteer > -30 )
				{
					_topSteer -= 5;
				}
			}
			else _topSteer -= _topSteer  * .04;
			_steer -= ( _steer - _topSteer ) * .5;
			//
			yaw((_scale * .1 * _speed * _steer) / 360);
            moveForward(_scale * .1 * _speed);
		}
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			switch(e.keyCode)
			{
				case Keyboard.A:
				_leftDown = true;
				break;
				case Keyboard.D:
				_rightDown = true;
				break;
				case Keyboard.W:
				_forwardDown = true;
				break;
				case Keyboard.S:
				_backwardDown = true;
				break;
				case Keyboard.SPACE:
				break;
				default:
				break;
			}
		}
		
		private function onKeyUp(e:KeyboardEvent):void
		{
			switch(e.keyCode)
			{
				case Keyboard.A:
				_leftDown = false;
				break;
				case Keyboard.D:
				_rightDown = false;
				break;
				case Keyboard.W:
				_forwardDown = false;
				break;
				case Keyboard.S:
				_backwardDown = false;
				break;
				case Keyboard.SPACE:
				break;
				default:
				break;
			}
		}
	}

}