package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import fl.core.UIComponent;
	import fl.controls.Label;
	import fl.controls.Button;
	import fl.controls.ComboBox;
	import fl.data.DataProvider;
	
	public class ModelsPanel extends Sprite
	{		
		public function ModelsPanel() 
		{
			var step1Label:Label = new Label();
            step1Label.text = '1. Wybierz plik modelu';
			step1Label.x = 10;
			step1Label.y = 10;
			step1Label.width = 190;
			addChild(step1Label);
			
			var modelSelectButton:Button = new Button();
			modelSelectButton.name = "modelSelect";
			modelSelectButton.label = "Wybierz model";
			modelSelectButton.x = 15;
			modelSelectButton.y = 27;
			modelSelectButton.width = 100;
			addChild(modelSelectButton);
			modelSelectButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var step2Label:Label = new Label();
            step2Label.text = '2. Ręcznie wybierz teksturę modelu';
			step2Label.x = 10;
			step2Label.y = 56;
			step2Label.width = 190;
			addChild(step2Label);
			
			var selectTextureButton:Button = new Button();
			selectTextureButton.name = "selectTexture";
			selectTextureButton.label = "Wybierz teksturę";
			selectTextureButton.x = 15;
			selectTextureButton.y = 73;
			selectTextureButton.width = 100;
			selectTextureButton.enabled = false;
			addChild(selectTextureButton);
			selectTextureButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var step3Label:Label = new Label();
            step3Label.text = '3. Wraj model';
			step3Label.x = 10;
			step3Label.y = 103;
			addChild(step3Label);
			
			var loadModelButton:Button = new Button();
			loadModelButton.name = "loadModel";
			loadModelButton.label = "Wczytaj model";
			loadModelButton.x = 15;
			loadModelButton.y = 121;
			loadModelButton.width = 100;
			loadModelButton.enabled = false;
			addChild(loadModelButton);
			loadModelButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var dp:DataProvider = new DataProvider();
			dp.addItem( { label: 'WireframeMaterial', data: 'WireframeMaterial' } );
			dp.addItem( { label: 'WireColorMaterial', data: 'WireColorMaterial' } );
			dp.addItem( { label: 'BitmapMaterial', data: 'BitmapMaterial' } );
			
			var materialSelect:ComboBox = new ComboBox();
			materialSelect.name = 'materialSelect';
			materialSelect.enabled = false;
			materialSelect.dataProvider = dp;
			materialSelect.width = 150;
			materialSelect.x = 15;
			materialSelect.y = 163;
			addChild(materialSelect);
			materialSelect.addEventListener(Event.CHANGE, materialChange);
			
			var playAnimationButton:Button = new Button();
			playAnimationButton.name = "playAnimation";
			playAnimationButton.label = "Włącz animację";
			playAnimationButton.x = 15;
			playAnimationButton.y = 193;
			playAnimationButton.width = 100;
			playAnimationButton.enabled = false;
			addChild(playAnimationButton);
			playAnimationButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var scaleLabel:Label = new Label();
            scaleLabel.text = 'Skala modelu';
			scaleLabel.x = 10;
			scaleLabel.y = 225;
			addChild(scaleLabel);
			
			var scaleLessButton:Button = new Button();
			scaleLessButton.name = "scaleLess";
			scaleLessButton.label = "-";
			scaleLessButton.x = 15;
			scaleLessButton.y = 245;
			scaleLessButton.width = 30;
			scaleLessButton.enabled = false;
			addChild(scaleLessButton);
			scaleLessButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var scaleMoreButton:Button = new Button();
			scaleMoreButton.name = "scaleMore";
			scaleMoreButton.label = "+";
			scaleMoreButton.x = 55;
			scaleMoreButton.y = 245;
			scaleMoreButton.width = 30;
			scaleMoreButton.enabled = false;
			addChild(scaleMoreButton);
			scaleMoreButton.addEventListener(MouseEvent.CLICK, buttonClick);
		}
		
		private function materialChange(e:Event):void
		{
			dispatchEvent(new Event(e.target.value + 'Event'));
		}
		
		private function buttonClick(e:MouseEvent):void
		{
			dispatchEvent(new Event(e.target.name + 'Event'));
		}
		
		public function setAvailability(objectName:String,enabled:Boolean):void
		{
			if (getChildByName(objectName) is UIComponent) 
			{
				(getChildByName(objectName) as UIComponent).enabled = enabled;
			}
		}
		
		public function setLabel(labelName:String,val:String):void
		{
			if (getChildByName(labelName) is Button) 
			{
				(getChildByName(labelName) as Button).label = val;
			}
		}
		
		public function draw(_width:Number, _height:Number, _color:uint = 0xF1F1F1, _alpha:int = 1):void
		{
			graphics.clear();
			graphics.beginFill(_color,_alpha);
			graphics.drawRect(0, 0, _width, _height);
			graphics.endFill();
		}
	}
}