package  
{
	import away3d.containers.View3D;
	import away3d.primitives.Skybox;
	import away3d.materials.BitmapFileMaterial;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.*;
	
	public class skyboxExample extends Sprite
	{
		private var view:View3D;
		private var background:Skybox;
		
		public function skyboxExample() 
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			view = new View3D();
			addChild(view);
			background = new Skybox(
				new BitmapFileMaterial('../../resources/bitmaps/skybox/front.jpg'),
				new BitmapFileMaterial('../../resources/bitmaps/skybox/left.jpg'),
				new BitmapFileMaterial('../../resources/bitmaps/skybox/back.jpg'),
				new BitmapFileMaterial('../../resources/bitmaps/skybox/right.jpg'),
				new BitmapFileMaterial('../../resources/bitmaps/skybox/up.jpg'),
				new BitmapFileMaterial('../../resources/bitmaps/skybox/down.jpg')
			);
			view.scene.addChild(background);
			onResize();
			stage.addEventListener(Event.RESIZE, onResize);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;
		}
		
		private function onEnterFrame(e:Event):void
		{
			view.camera.rotationX += .25;
			view.camera.rotationY -= .1;
			view.render();
		}
	}
}