﻿package away3d.loaders.utils
{
	import away3d.core.base.*;
    import away3d.materials.*;
	
    import flash.utils.*;
    
    /**
    * Store for all materials associated with an externally loaded file.
    */
    public dynamic class CentralMaterialLibrary extends Dictionary
    {
		/**
    	 * Returns a material for the given name reference in the library.
    	 */
        public static function addMaterial(material:Material, mesh:Mesh = null, id:String = "", url:String = ""):void
        {
        	if (id == "" || CentralMaterialLibrary[id])
        		return;
			
        	//trace("material["+id+"]");
			CentralMaterialLibrary[id] = [material, mesh, url];
        }
    	
    	/**
    	 * Returns a material for the given name reference in the library.
    	 */
        public static function getMaterial(id:String):Material
        {
        	if (CentralMaterialLibrary[id])
        		return CentralMaterialLibrary[id][0];
        	
        	return null;
        }
		
		/**
    	 * Replace a material for the given name reference in the library.
    	 */
        public static function updateMaterial(id:String, mat:Material):void
        {
				if (CentralMaterialLibrary[id]){
					CentralMaterialLibrary[id][0] = mat;
					CentralMaterialLibrary[id][2] = "";
				}
        }
		
		/**
    	 * Returns a mesh for the given name reference in the library.
    	 */
        public static function getMeshFromMaterialName(id:String):Mesh
        {
        	if (CentralMaterialLibrary[id])
        		return CentralMaterialLibrary[id][1];
        	
        	return null;
        }
		
		/**
    	 * Returns a url for the given name reference in the library.
    	 */
        public static function getURLMaterial(id:String):String
        {
        	if (CentralMaterialLibrary[id])
        		return CentralMaterialLibrary[id][2];
        	
        	return null;
        }
		 
		/**
    	 * clears a material for the given name reference in the library.
    	 */
        public static function clearMaterial(id:String):void
        {
			//need add dispose for bitmaps...
        	if (CentralMaterialLibrary[id])
				CentralMaterialLibrary[id][0] = null;
        		CentralMaterialLibrary[id] = null;
        	
        }
        
    }
}