package away3d.events
{
	import flash.events.Event;
	
	public class BSPBuildEvent extends Event {
		
		// total process
		public var percent:Number = 0;
		//represents the actual index
		public var count:int = 0;
		// process percent on actual processed image
		public var percentPart:Number = 0;
		// total to be processed
		public var totalParts:Number = 1;
		// messages dispatched during the build process
		public var message:String;
		// additional data concerning the event
		public var data : Object;
		
		/**
    	 * Defines the value of the type property of a buildcomplete event object.
    	 */
    	public static const BUILD_COMPLETE:String = "buildcomplete";
		
		/**
    	 * Defines the value of the type property of a buildprogress event object.
    	 */
    	public static const BUILD_PROGRESS:String = "buildprogress";
		
		/**
    	 * Defines the value of the type property of a buildcount event object.
    	 */
    	public static const BUILD_COUNT:String = "buildcount";
		
		/**
    	 * Defines the value of the type property of a buildwarning event object.
    	 */
    	public static const BUILD_WARNING:String = "buildwarning";

		/**
    	 * Defines the value of the type property of a builderror event object.
    	 */
    	public static const BUILD_ERROR:String = "builderror";

		public static const BUILD_CANCELED : String = "buildCanceled";

		function BSPBuildEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false){
			super(type, bubbles, cancelable);
		}
		
		override public function clone() : Event
		{
			var event : BSPBuildEvent = new BSPBuildEvent(type);
			event.data = data;
			event.message = message;
			event.percent = percent;
			event.count = count;
			event.percentPart = percentPart;
			event.totalParts = totalParts;
			
			return event;
		}
	}
}
 