package
{	
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Vector3D;
	//
	import away3d.containers.View3D;
	import away3d.primitives.Plane;
	import away3d.materials.BitmapFileMaterial;
	import away3d.cameras.SpringCam;
	
	public class tppExample extends Sprite
	{
		private var view:View3D;
		private var camera:SpringCam;
		private var ground:Plane;
		private var car:Car;
		
		public function tppExample() 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			//
			view = new View3D();
			addChild(view);
			ground = new Plane();
			ground.y = -50;
			ground.pushback = true;
			ground.material = new BitmapFileMaterial('../../resources/bitmaps/skybox/down.jpg');
			ground.segmentsH = ground.segmentsW = 10;
			ground.height = 1000;
			ground.width = 1000;
			view.scene.addChild(ground);
			/*
			 */
			initPlayer();
			initCamera();
			onResize();
		}
		
		private function initPlayer():void
		{
			car = new Car(stage);
			car.pushfront = true;
			view.scene.addChild(car);
		}
		
		private function initCamera():void
		{
			camera = new SpringCam();
			camera.stiffness = 6;
			camera.damping = 10;
			camera.mass = 10;
			camera.positionOffset = new Vector3D(0, 50, -200);
			camera.target = car;
			view.camera = camera;
		}
		
		private function onEnterFrame(e:Event):void
		{
			car.update();
			camera.view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
	}
}