package
{
	import away3d.primitives.Trident;
	import away3d.materials.BitmapFileMaterial;
	import away3d.core.base.Mesh;
	import away3d.loaders.data.AnimationData;
	import away3d.containers.ObjectContainer3D;
	import away3d.loaders.Loader3D;
	import away3d.loaders.Md2;
	import flash.geom.Point;
	import flash.geom.Vector3D;
	import flash.events.Event;

	public class Skeleton extends ObjectContainer3D
	{
		private var modelLoader:Loader3D;
		private var animationData:AnimationData;		
		private var _destination:Point;
		private var _speed:Number = 20;
		private var _bounds:Number = 10;
		private var model:Mesh;
		public var isMoving:Boolean = false;
		
		public function Skeleton():void
		{
			var tri:Trident = new Trident(100,true);
			//addChild(tri);
			modelLoader = Md2.load('../../resources/models/md2/hueteotl/TRIS.MD2');
			modelLoader.addOnSuccess(modelLoaded);
		}
		
		private function modelLoaded(e:Event):void
		{
			var mat:BitmapFileMaterial = new BitmapFileMaterial('../../resources/models/md2/hueteotl/hueteotl.jpg');
			model = modelLoader.handle as Mesh;
			model.rotationY = 90;
			model.y = 60;
			model.scale(.025);
			model.material = mat;
			animationData = model.animationLibrary.getAnimation('stand');
			animationData.animator.play();
			addChild(model);
		}
		
		public function set destination(val:Point):void
		{
			_destination = val;
			lookAt(new Vector3D(_destination.x, y,_destination.y));
			if (!isMoving)
			{
				isMoving = true;
				animationData = model.animationLibrary.getAnimation('run');
				animationData.animator.play();
			}
		}
		
		public function update():void
		{
			if (isMoving)
			{			
				var xdiff = _destination.x - x;
				var zdiff = _destination.y - z;
				var diff = Math.sqrt(Math.pow(xdiff, 2) + Math.pow(zdiff, 2));
				var fraction = _speed / diff;
				x += fraction * xdiff;
				z += fraction * zdiff;
				
				if ((x > (_destination.x - _bounds) && x < (_destination.x + _bounds)) && (z > (_destination.y - _bounds) && z < (_destination.y + _bounds)))
				{
					isMoving = false;
					animationData = model.animationLibrary.getAnimation('stand');
					animationData.animator.play();
				}
			}
		}
	}
}