package 
{
	import away3d.materials.ShadingColorMaterial;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Vector3D;
	//
	import away3d.containers.View3D;
	import away3d.containers.ObjectContainer3D;
	import away3d.lights.*;
	import away3d.materials.*;
	import away3d.primitives.Sphere;
	/**
	 * ...
	 * @author 
	 */
	public class AmbientLight3DExample extends Sprite 
	{
		private var view:View3D;
		private var obj:ObjectContainer3D;
		private var light:AmbientLight3D;
		
		public function AmbientLight3DExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.addEventListener(Event.RESIZE, onResize);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			initPanelListeners();
			
			view = new View3D();
			addChild(view);
			
			addLights();
			addObjects();
			
			onResize();
		}
		
		private function initPanelListeners():void
		{
			panel.ambientText.addEventListener(Event.CHANGE, updateLight);
		}
		
		private function addLights():void
		{
			light = new AmbientLight3D();
			panel.ambientText.text = light.ambient;
			view.scene.addLight(light);
		}
		
		private function addObjects():void
		{
			obj = new ObjectContainer3D();
			var sph1:Sphere = new Sphere( { radius:50, material:new PhongColorMaterial(0xFF0000), x:-150 } );
			var sph2:Sphere = new Sphere( { radius:50, material:new PhongColorMaterial(0xFF0000), x:150 } );
			obj.addChild(sph1);
			obj.addChild(sph2);
			view.scene.addChild(obj);
		}
		
		private function updateLight(e:Event):void
		{
			light.ambient = Number(panel.ambientText.text);
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
		
		private function onEnterFrame(e:Event):void
		{
			obj.rotationY--;
			view.render();
		}
	}
}