﻿package
{
	import away3d.primitives.AbstractPrimitive;
	import away3d.arcane;
    import away3d.core.base.UV;
	use namespace arcane;
	
    public class Arrowhead extends AbstractPrimitive
    {
        private var _height:Number;
		private var _width:Number;
        private var _sides:Number;
		private var _ang:Number;
        
		public function Arrowhead(init:Object = null)
        {
            super(init);
            _width = ini.getNumber("width", 100, { min:1 } );
			_height = ini.getNumber("height", 150, {min:1});
			_sides = ini.getInt("sides", 3, { min:1 } );
			_ang = 360 / _sides;
        }
		
    	protected override function buildPrimitive():void
    	{
    		super.buildPrimitive();
			var i:Number = _sides;
			while(i--)
			{
				var currAng = i * _ang;
				var a = createVertex(0, _height, 0);
				var b = createVertex(0, 0, 0);
				var c = createVertex(Math.cos(currAng / 180 * Math.PI) * (_width * .5), 0, Math.sin(currAng / 180 * Math.PI) * (_width * .5));
				addFace(createFace(a, b, c, null, new UV(0, 0), new UV(1, 0), new UV(0, 1)));
			}
    	}
    	
    	public function get width():Number
    	{
    		return _width;
    	}
    	
		public function set width(val:Number):void
    	{
    		if (_width == val) return;
    		_width = val;
			_primitiveDirty = true;
    	}
		
		public function get height():Number
    	{
    		return _height;
    	}
		
		public function set height(val:Number):void
    	{
    		if (_height == val) return;
    		_height = val;
			_primitiveDirty = true;
    	}
		
    	public function get sides():Number
    	{
    		return _sides;
    	}
    	
    	public function set sides(val:Number):void
    	{
    		if (_sides == val) return;
    		_sides = val;
			_ang = 360 / val;
			_primitiveDirty = true;
    	}
    }
}
