package
{
	import away3d.core.base.Mesh;
	import away3d.core.geom.Path;
	import away3d.core.utils.Cast;
	import away3d.modifiers.PathAlignModifier;
	import away3d.primitives.Sphere;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.net.URLLoader;
	import flash.net.URLLoaderDataFormat;
	import flash.net.URLRequest;
	import flash.events.Event;
	import flash.geom.Vector3D;
	
	import away3d.containers.ObjectContainer3D;
	import away3d.containers.View3D;
	import away3d.extrusions.TextExtrusion;
	import away3d.lights.PointLight3D;
	import away3d.materials.*;
	import away3d.primitives.TextField3D;
	import wumedia.vector.VectorText;

	public class TextField3DExample extends Sprite
	{
		private var view:View3D;
		private var loader:URLLoader;
		private var pointLight:PointLight3D;
		private var mat:*;
		private var all:ObjectContainer3D = new ObjectContainer3D();
		private var earth:Sphere;
		
		public function TextField3DExample()
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			view = new View3D();
			view.camera.z = -1500;
			addChild(view);
			
			loader = new URLLoader();
            loader.dataFormat = URLLoaderDataFormat.BINARY;
			loader.addEventListener(Event.COMPLETE, onFontLoaded);
            loader.load(new URLRequest("font.swf"));
			/*
			pointLight=new PointLight3D();
			pointLight.position=new Vector3D(0,150,-300);
			pointLight.ambient = .3;
			pointLight.diffuse = .2;
			pointLight.brightness = 4;
			view.scene.addLight(pointLight);
			*/
			earth = new Sphere( { material:new BitmapMaterial(Cast.bitmap('earthMap')), radius:256, segmentsH:16, segmentsW:16, pushback:true } );
			view.scene.addChild(earth);
			onResize();
		}
		
		private function onFontLoaded(e:Event):void
		{		
		    VectorText.extractFont(loader.data);
			var textfield:TextField3D = new TextField3D("Arial", { size:75, width:2000 } );
			textfield.material = new ColorMaterial(0xFFF700);
			textfield.text="Away3D przedstawia";
			textfield.bothsides = true;			
			textfield.align = VectorText.CENTER;
			
			all.addChild(textfield);
			view.scene.addChild(all);
			wrapText();
		}
		
		private function wrapText():void
		{
			var pathVectors:Array = [
				new Vector3D(0, 0, -300),
				new Vector3D(225, 0, -225),
				new Vector3D(300, 0, 0),
				new Vector3D(300, 0, 0),
				new Vector3D(225, 0, 225),
				new Vector3D(0, 0, 300),
				new Vector3D(0, 0, 300),
				new Vector3D(-225, 0, 255), 
				new Vector3D(-300, 0, 0),
				new Vector3D(-300, 0, 0),
				new Vector3D(-225, 0, -225),
				new Vector3D(0, 0, -300)
			];
			var path:Path = new Path(pathVectors);
			var pathAlign:PathAlignModifier = new PathAlignModifier(all.children[0] as Mesh, path);
			trace(pathAlign.arcLengthPrecision,pathAlign.offset);
			pathAlign.execute();
		}
		

		
		private function onEnterFrame(e:Event):void
		{
			earth.rotationY++;
			all.rotationY--;
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
	}
}