package
{
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Vector3D;
	import flash.geom.Matrix3D;
	import flash.media.Sound;
	import flash.net.URLRequest;
	//
	import away3d.audio.drivers.SimplePanVolumeDriver;
	import away3d.core.clip.FrustumClipping;
	import away3d.events.Object3DEvent;
	import away3d.containers.View3D;
	import away3d.audio.Sound3D;
	
	public class Sound3DExample extends Sprite
	{
		
		private var ch:crosshair;
		private var view:View3D;
		private var fpp:FPP;
		private var snd:Sound3D;
		private var snd2:Sound3D;
		private var spvd:SimplePanVolumeDriver;
		private var spvd2:SimplePanVolumeDriver;
		
		public function Sound3DExample() 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			//
			view = new View3D();
			view.clipping = new FrustumClipping( { minZ:10 } );
			addChild(view);
			//			
			ch = new crosshair();
			addChild(ch);
			fpp = new FPP(stage, { freeCamera:true, height:160 } );
			fpp
			view.camera = fpp;
			onResize();
			
			var building:Building = new Building(view.scene);
			building.buildCorridor();
			addSounds();
		}
		
		private function addSounds():void
		{
			/*
			 * Doors To Hell
			 */ 
			spvd = new SimplePanVolumeDriver();
			snd = new Sound3D(new Sound(new URLRequest('../../resources/sounds/scary_background_music.mp3')), view.camera, spvd);
			snd.position = new Vector3D(0, 26, 1810);
			view.scene.addChild(snd);
			spvd.volume = .75;
			snd.play();
			/*
			 * Begin
			 */
			spvd2 = new SimplePanVolumeDriver();
			snd2 = new Sound3D(new Sound(new URLRequest('../../resources/sounds/maniac_laugh.mp3')), view.camera, spvd2);
			snd2.position = new Vector3D(0, 26, -1810);
			spvd2.volume = .75;
			view.scene.addChild(snd2);
			snd2.play();
			//
			view.camera.addOnPositionChange(tracePosition);
		}
		
		private function tracePosition(e:Object3DEvent):void
		{
			snd._onSceneTransformChanged();
			snd2._onSceneTransformChanged();
		}
		
		private function onEnterFrame(e:Event):void
		{
			fpp.updateCamera();
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = ch.x = stage.stageWidth * .5;
			view.y = ch.y = stage.stageHeight * .5;			
		}
	}
}