package  
{
	import flash.display.Sprite;
	import flash.geom.Vector3D;
	import away3d.core.utils.Cast;
	import away3d.containers.Scene3D;
	import away3d.containers.ObjectContainer3D;
	import away3d.primitives.Plane;
	import away3d.primitives.data.CubeMaterialsData;
	import away3d.materials.BitmapMaterial;
	import away3d.materials.TransformBitmapMaterial;
	import away3d.materials.MovieMaterial;
	import away3d.primitives.Cube;
	/**
	 * ...
	 * @author 
	 */
	public class Building extends Sprite
	{
		private var scene:Scene3D;
		public var corridor_segments:Number = 8;
		private var wall_height:int = 256;
		private var wall_width:int = 508;
		private var wall_depth:int = 25;
		
		public function Building(scn:Scene3D) 
		{
			scene = scn;
		}
		
		public function buildCorridor():void
		{
			var length:Number = corridor_segments * wall_width;
			var corridor:ObjectContainer3D = new ObjectContainer3D();
			var floor:Plane = new Plane( { width:wall_width, height:length, segmentsW:corridor_segments, segmentsH:corridor_segments * 2, material:new TransformBitmapMaterial(Cast.bitmap('corridorFloor'), { repeat:true, scaleX:.5, scaleY:254 / length } ), pushback:true } );
			var ceiling:Plane = new Plane( { width:wall_width, height:length, y:wall_height, segmentsW:corridor_segments, segmentsH:corridor_segments * 2, bothsides:true, back:new TransformBitmapMaterial(Cast.bitmap('ceiling'), { repeat:true, scaleX:.5, scaleY:254 / length } ), pushback:true } );
			var longWallL:Cube = new Cube();
			longWallL.depth = length;
			longWallL.width = wall_depth;
			longWallL.height = wall_height;
			longWallL.position = new Vector3D( -266.5, wall_height * .5, 0);
			//
			var longWallR:Cube = new Cube();
			longWallR.depth = length;
			longWallR.width = wall_depth;
			longWallR.height = wall_height;
			longWallR.position = new Vector3D(266.5, wall_height * .5, 0);
			//
			var longWallMaterials:CubeMaterialsData = new CubeMaterialsData();
			longWallMaterials.front = new BitmapMaterial(Cast.bitmap('corridorWall2'));
			longWallMaterials.back = new BitmapMaterial(Cast.bitmap('corridorWall2'));
			longWallMaterials.left = new TransformBitmapMaterial(Cast.bitmap('corridorWall'), { repeat:true, scaleX:1 / corridor_segments } );
			longWallMaterials.right = new TransformBitmapMaterial(Cast.bitmap('corridorWall'), { repeat:true, scaleX:1 / corridor_segments } );
			//
			longWallL.cubeMaterials = longWallMaterials; 
			longWallR.cubeMaterials = longWallMaterials; 
			//
			var doorsToHellMaterials:CubeMaterialsData = new CubeMaterialsData();
			doorsToHellMaterials.front = new BitmapMaterial(Cast.bitmap('doorsToHell'));
			doorsToHellMaterials.back = new BitmapMaterial(Cast.bitmap('doorsToHell'));
			doorsToHellMaterials.left = new BitmapMaterial(Cast.bitmap('corridorWall2'));
			doorsToHellMaterials.right = new BitmapMaterial(Cast.bitmap('corridorWall2'));
			var doorsToHell:Cube = new Cube( { cubeMaterials:doorsToHellMaterials } );
			doorsToHell.position = new Vector3D( 0, wall_height * .5, length * .5 + wall_depth * .5);
			doorsToHell.depth = wall_depth;
			doorsToHell.width = wall_width;
			doorsToHell.height = wall_height;
			//
			var backWallMaterials:CubeMaterialsData = new CubeMaterialsData();
			backWallMaterials.front = new BitmapMaterial(Cast.bitmap('corridorWall'));
			backWallMaterials.back = new BitmapMaterial(Cast.bitmap('corridorWall'));
			backWallMaterials.left = new BitmapMaterial(Cast.bitmap('corridorWall2'));
			backWallMaterials.right = new BitmapMaterial(Cast.bitmap('corridorWall2'));
			var backWall:Cube = new Cube( { cubeMaterials:backWallMaterials } );
			backWall.position = new Vector3D( 0, wall_height * .5, -length * .5 - wall_depth * .5);
			backWall.depth = wall_depth;
			backWall.width = wall_width;
			backWall.height = wall_height;
			//
			corridor.addChild(floor);
			corridor.addChild(ceiling);
			corridor.addChild(backWall);
			corridor.addChild(doorsToHell);
			corridor.addChild(longWallL);
			corridor.addChild(longWallR);
			scene.addChild(corridor);
		}
	}
}