﻿package away3d.sprites
{
    import flash.display.*;
	
	/**
	 * Spherical billboard (always facing the camera) sprite object that uses a movieclip as it's texture.
	 * Draws individual display objects inline with z-sorted triangles in a scene.
	 */
    public class MovieClipSprite extends Sprite3D
    {
    	private var _movieClip:DisplayObject;
		
		/**
		 * Defines the display object to use for the sprite.
		 */
        public function get movieClip():DisplayObject
        {
            return _movieClip;
        }
		
        public function set movieClip(value:DisplayObject):void
        {
            if (_movieClip == value)
                return;
            
            _movieClip = spriteVO.displayObject = value;
        }
        
		/**
		 * Creates a new <code>MovieClipSprite</code> object.
		 * 
		 * @param	movieClip			The displayobject to use as the sprite texture.
		 * @param	scaling	[optional]	An initialisation object for specifying default instance properties.
		 */
        public function MovieClipSprite(movieClip:DisplayObject, align:String = "center", scaling:Number = 1, distanceScaling:Boolean = true)
        {
            super(null, 10, 10, 0, align, scaling, distanceScaling);
			
            this.movieClip = movieClip;
        }
    }
}