﻿//import the EventDispatcher object class
import mx.events.EventDispatcher;
class Creature extends MovieClip {
	//create a couple of properties
	private var xDist:Number;
	private var yDist:Number;
	private var creatureSpeed:Number;
	//create a couple of methods to use in Flash
	public var addEventListener:Function;
	public var removeEventListener:Function;
	//create the method to trigger the event
	private var dispatchEvent:Function;
	function Creature() {
		this.changeColor();
		//initialize the EventDispatcher
		EventDispatcher.initialize(this);
		//place it at a random spot
		this._x = Math.random()*550;
		this._y = Math.random()*400;
		//set the initial speed
		this.speed = 10;
		//where all the magic happens
		this.onEnterFrame=function(){
		xDist = _root._xmouse-this._x;
		yDist = _root._ymouse-this._y;
		this._x+=xDist/creatureSpeed;
		this._y+=yDist/creatureSpeed;
		if(this.hitTest(_root._xmouse,_root._ymouse)){
			dispatchEvent({type:"onGotcha"});
			}
		}
	}
	//create the getter setter methods
	public function get speed():Number{
		return this.creatureSpeed;
	}
	public function set speed(amount:Number):Void{
		this.creatureSpeed = amount;
	}
	//create the method to change its color
	public function changeColor():Void{
		//give it a random color
		var myColor:Color = new Color(this);
		myColor.setRGB(Math.random()*0x10000000);
		delete myColor;
	}
}