﻿function configureTool(){
	myTool = fl.tools.activeTool;
	myTool.setToolName("Heart");
	myTool.setIcon("Heart.png");
	myTool.setMenuString("Heart Tool");
	myTool.setToolTip("Heart Tool");
}

function drawHeart(startX,startY,theWidth,theHeight){
	if(fl.tools.shiftIsDown){
		if(Math.abs(theWidth) > Math.abs(theHeight)){
			if(theWidth<0 && theHeight<0){
				theHeight = theWidth;
			}else if(theWidth<0){
				theHeight = -theWidth;
			}else if(theHeight<0){
				theHeight = -theWidth;
			}else{
				theHeight = theWidth;
			}
		}else if(Math.abs(theHeight) > Math.abs(theWidth)){
			if(theHeight<0 && theWidth<0){
				theWidth = theHeight;
			}else if(theHeight<0){
				theWidth = -theHeight;
			}else if(theWidth<0){
				theWidth = -theHeight;
			}else{
				theWidth = theHeight;
			}
		}
	}
	thePath.addCurve(startX+(theWidth/2),startY+(theHeight*.3),startX+(theWidth/2),startY,startX+(theWidth/4),startY);
	thePath.addCurve(startX+(theWidth/4),startY,startX,startY,startX,startY+(theHeight*.3));
	thePath.addCurve(startX,startY+(theHeight*.3),startX+(theWidth/100),startY+(theHeight*.75),startX+(theWidth/2),startY+theHeight);
	thePath.addCurve(startX+(theWidth/2),startY+theHeight,startX+(theWidth-(theWidth/100)),startY+(theHeight*.75),startX+theWidth,startY+(theHeight*.3));
	thePath.addCurve(startX+theWidth,startY+(theHeight*.3),startX+theWidth,startY,startX+(theWidth*.75),startY);
	thePath.addCurve(startX+(theWidth*.75),startY,startX+(theWidth/2),startY,startX+(theWidth/2),startY+(theHeight*.3));
}

function activate(){
	myTool = fl.tools.activeTool;
}

function mouseDown(){
	fl.drawingLayer.beginDraw();
}
function mouseMove(){
	if(fl.tools.mouseIsDown){
		var difX=fl.tools.penLoc.x-fl.tools.penDownLoc.x;
		var difY=fl.tools.penLoc.y-fl.tools.penDownLoc.y;
		fl.drawingLayer.beginFrame();
		drawLayer = fl.drawingLayer;
		thePath = drawLayer.newPath();
		drawHeart(fl.tools.penDownLoc.x,fl.tools.penDownLoc.y,difX,difY);
		drawLayer.drawPath(thePath);
		fl.drawingLayer.endFrame();
	}
}

function mouseUp(){
	fl.drawingLayer.endDraw();
	thePath.makeShape();
}