// Użyty tu blok ifdef to standardowy sposób tworzenia makr, który ułatwia eksportowanie
// kodu z biblioteki DLL. Wszystkie pliki z biblioteki DLL są kompilowane z symbolem
// CINTEROPDLL_EXPORTS zdefiniowanym w wierszu poleceń. W projektach używających tej 
// biblioteki tego symbolu nie należy definiować. Dzięki temu w innych projektach, w których
// w plikach źródłowych dołączany jest ten plik, funkcje z CINTEROPDLL_API są traktowane jak
// importowane z pliku DLL, natomiast w samym pliku DLL symbole zdefiniowane przy użyciu
// tego makra są traktowane jak eksportowane jednostki.
#ifdef CINTEROPDLL_EXPORTS
#define CINTEROPDLL_API __declspec(dllexport)
#else
#define CINTEROPDLL_API __declspec(dllimport)
#endif
extern "C" {

typedef struct _Complex {
	double re;
	double im;
} Complex;

int CINTEROPDLL_API Sum(int i, int j);
Complex CINTEROPDLL_API SumC(Complex c1, Complex c2);
void CINTEROPDLL_API ZeroC(Complex* c);

void CINTEROPDLL_API HelloWorld();

void CINTEROPDLL_API echo(char* str);

void CINTEROPDLL_API sayhello(char* str, int sz);

void CINTEROPDLL_API sayhellow(wchar_t* str, int sz);

typedef int (CALLBACK *TRANSFORM_CALLBACK)(int);

void CINTEROPDLL_API transformArray(int* data, int count, TRANSFORM_CALLBACK fn);
}