namespace ReactivePiglets

open WebSharper
open WebSharper.JavaScript
open WebSharper.UI.Next
open WebSharper.UI.Next.Html
open WebSharper.UI.Next.Client
open WebSharper.Forms
open WebSharper.Forms.Bootstrap

[<JavaScript>]
module LoginForm =
    module C = Controls.Simple

    let Main =
        Form.Return (fun user pass -> (user, pass))
        <*> (Form.Yield ""
            |> Validation.IsNotEmpty "Podaj nazwe")
        <*> (Form.Yield ""
            |> Validation.IsNotEmpty "Podaj haslo")
        |> Form.WithSubmit
        |> Form.Run (fun (user, pass) ->
            JS.Alert ("Witaj, " + user + "!"))
        |> Form.Render (fun user pass submit ->
            div [
                C.InputWithError "Nazwa" user submit.View
                C.InputPasswordWithError "Haslo" pass submit.View
                C.Button "Log in" submit.Trigger
                C.ShowErrors submit.View  // Opcjonalnie (aby zobaczyć listę błędów)
            ]
        )
        |> fun s -> s.RunById "main"
