namespace ReactiveFormlets

open WebSharper
open WebSharper.JavaScript
open WebSharper.UI.Next
open WebSharper.UI.Next.Html
open WebSharper.UI.Next.Client
open WebSharper.UI.Next.Formlets

[<JavaScript>]
module LoginForm =

    let Main =
        let username = Var.Create ""
        let password = Var.Create ""
        Formlet.Return (fun user pass -> (user, pass))
        <*> (Controls.InputVar username
            |> Formlet.WithLabel (text "Nazwa: "))
        <*> (Controls.InputVar password
            |> Formlet.WithLabel (text "Haslo: "))
        |> Formlet.WithSubmit "Zaloguj"
        |> Formlet.WithFormContainer
        |> Formlet.Run (fun (user, pass) ->
            JS.Alert ("Witaj, " + user + "!"))
        |> fun s -> s.RunById "main"
