// Plik sygnaturowy dla parsera generowanego przez FsYacc
module Symbolic.Expressions.ExprParser
type token = 
  | EOF
  | LPAREN
  | RPAREN
  | PLUS
  | MINUS
  | TIMES
  | DIV
  | HAT
  | SIN
  | COS
  | E
  | ID of (string)
  | FLOAT of (float)
  | INT of (int)
type tokenId = 
    | TOKEN_EOF
    | TOKEN_LPAREN
    | TOKEN_RPAREN
    | TOKEN_PLUS
    | TOKEN_MINUS
    | TOKEN_TIMES
    | TOKEN_DIV
    | TOKEN_HAT
    | TOKEN_SIN
    | TOKEN_COS
    | TOKEN_E
    | TOKEN_ID
    | TOKEN_FLOAT
    | TOKEN_INT
    | TOKEN_end_of_input
    | TOKEN_error
type nonTerminalId = 
    | NONTERM__startexpr
    | NONTERM_expr
    | NONTERM_number
    | NONTERM_exp
    | NONTERM_term
/// Ta funkcja odwzorowuje tokeny na indeksy całkowitoliczbowe
val tagOfToken: token -> int

/// Ta funkcja odwzorowuje indeksy całkowitoliczbowe na symboliczne indentyfikatory tokenów
val tokenTagToTokenId: int -> tokenId

/// Ta funkcja odwzorowuje indeksy zwracane w błędach składni na łańcuchy znaków reprezentujące błąd niekrytyczny generowany w danym środowisku
val prodIdxToNonTerminal: int -> nonTerminalId

/// Ta funkcja pobiera nazwę tokenu jako łańcuch znaków
val token_to_string: token -> string
val expr : (Microsoft.FSharp.Text.Lexing.LexBuffer<'cty> -> token) -> Microsoft.FSharp.Text.Lexing.LexBuffer<'cty> -> (Expr) 
