﻿module Test1

open System
open NUnit.Framework
open IsPalindrome

[<TestFixture>]
type Test() =

    let posTests(strings) =
        for s in strings do
            Assert.That(isPalindrome s, Is.True,
                          sprintf "isPalindrome(\"%s\") musi zwrócić true" s)

    let negTests(strings) =
        for s in strings do
            Assert.That(isPalindrome s, Is.False,
                           sprintf "isPalindrome(\"%s\") musi zwrócić false" s)

    [<Test>]
    member x.EmptyString () =
        Assert.That(isPalindrome(""), Is.True,
                      "isPalindrome musi zwrócić true dla pustego łańcucha znaków")

    [<Test>]
    member x.SingleChar () = posTests ["a"]

    [<Test>]
    member x.EvenPalindrome () = posTests ["aa"; "abba"; "abaaba"]

    [<Test>]
    member x.OddPalindrome () = posTests ["aba"; "abbba"; "abababa"]

    [<Test>]
    member x.WrongString () = negTests ["as"; "F# jest wspaniały"; "super"]