var bcrypt = require('bcryptjs');

exports.checkAdmin = function(request, response, next) {
  if (request.session && request.session.auth && request.session.userId && request.session.admin) {
    console.info('Dostęp dla administratora: ' + request.session.userId);
    return next();
  } else {
    next('Użytkownik nie jest administratorem.');
  }
};

exports.checkUser = function(req, res, next) {
  if (req.session && req.session.auth && req.session.userId && (req.session.user.approved || req.session.admin)) {
    console.info('Dostęp dla użytkownika: ' + req.session.userId);
    return next();
  } else {
    next(new Error('Użytkownik nie jest zalogowany.'));
  }
};

exports.checkApplicant = function(req, res, next) {
  if (req.session && req.session.auth && req.session.userId && (!req.session.user.approved || req.session.admin)) {
    console.info('Dostęp dla użytkownika: ' + req.session.userId);
    return next();
  } else {
    next('Użytkownik nie jest zalogowany.');
  }
};

exports.login = function(req, res, next) {
  console.log('Zalogowanie użytkownika za pomocą adresu e-mail:', req.body.email)
  req.db.User.findOne({
      email: req.body.email
    },null, {
      safe: true
    },
    function(err, user) {
      if (err) return next(err);
      if (user) {
        bcrypt.compare(req.body.password, user.password, function(err, match) {
          if (match) {
            req.session.auth = true;
            req.session.userId = user._id.toHexString();
            req.session.user = user;
            if (user.admin) {
              req.session.admin = true;
            }
            console.info('Logowanie użytkownika: ' + req.session.userId);
            res.status(200).json({
              msg: 'Uwierzytelniony'
            });
          } else {
            next(new Error('Nieprawidłowe hasło'));
          }
        });
      } else {
        next(new Error('Nie znaleziono użytkownika.'));
      }
    });
};

exports.logout = function(req, res) {
  console.info('Wylogowanie użytkownika: ' + req.session.userId);
  req.session.destroy(function(error) {
    if (!error) {
      res.send({
        msg: 'Wylogany'
      });
    }
  });
};

exports.profile = function(req, res, next) {
  var fields = 'firstName lastName displayName' +
    ' headline photoUrl admin approved banned' +
    ' role angelUrl twitterUrl facebookUrl linkedinUrl githubUrl';
  req.db.User.findProfileById(req.session.userId, fields, function(err, obj) {
    console.log('err', err)
    if (err) return next(err);
    res.status(200).json(obj);
  });
};

exports.delProfile = function(req, res, next) {
  console.log('Usunięcie profilu');
  console.log(req.session.userId);
  req.db.User.findByIdAndRemove(req.session.user._id, {}, function(err, obj) {
    if (err) next(err);
    req.session.destroy(function(error) {
      if (err) {
        next(err)
      }
    });
    res.status(200).json(obj);
  });
};