<?xml version='1.0'?>
<xsl:stylesheet version="1.0"
	xmlns:msxsl="urn:schemas-microsoft-com:xslt"	
	xmlns:xd="http://schemas.microsoft.com/office/infopath/2003"
	xmlns:ixsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:out="output.xsl"
	xmlns:outmsxsl="output.msxsl.xsl">

<!-- File: Downlevel view generation transformation XSL					-->
<!-- $TODO: insert legal information									-->


<xsl:output 
		xmlns:msxsl="urn:schemas-microsoft-com:xslt"
		indent="yes"
		cdata-section-elements="script msxsl:script"
		encoding="UTF-8"
		method="xml"/>

<!-- ======================================================================	-->
<!-- Alias out: for outputting XSL from this XSL 							-->
<!-- Alias outmsxsl: for outputting msxsl:script blocks from this XSL		-->

<xsl:namespace-alias stylesheet-prefix="out" result-prefix="xsl" />
<xsl:namespace-alias stylesheet-prefix="outmsxsl" result-prefix="msxsl" />

<!-- ======================================================================	-->
<!-- identity transformation rule 											-->

<xsl:template match="@*|node()">
	<xsl:copy>
		<xsl:apply-templates select="@*|node()"/>
	</xsl:copy>
</xsl:template>

<!-- ======================================================================	-->
<!-- Rule to strip all contentEditable attributes -->

<xsl:template match="@*[0 = msxsl:string-compare(name(), 'contentEditable', '', 'i')]"/>

<!-- ======================================================================	-->
<!-- HTML HEAD element - add a BASE tag										-->

<xsl:template match="*[0 = msxsl:string-compare(name(), 'head', '', 'i')]">
	<xsl:copy>
		<!-- establish the BASE URL for the resultant view to be that of	-->
		<!-- the view XSL's location.										-->
		
		<BASE>
			<out:attribute name="HREF">
				<out:value-of select="xd:getXSLTDocURLBase(document(''))" />
			</out:attribute>
		</BASE>
		
		<xsl:apply-templates select="@*|node()"/>
	</xsl:copy>
</xsl:template>

<!-- ======================================================================	-->
<!-- Rule to strip all xsl:otherwise that will print 'click here' text		-->
<!-- (copy the choose and when content only) 								-->

<xsl:template match="ixsl:choose[ixsl:when/ixsl:apply-templates and ixsl:otherwise/*[@xmlToEdit]]">
	<xsl:copy>
		<xsl:apply-templates select="ixsl:when" />
	</xsl:copy>
</xsl:template>

<!-- ======================================================================	-->
<!-- Rule to kick in the rich-text copy mode								-->

<xsl:template match="ixsl:copy-of">
	<out:apply-templates select="{@select}" mode="RichCopyExcludeEncodedImages" />
</xsl:template>

<!-- ======================================================================	-->
<!-- Rule to strip all and buttons											-->

<xsl:template match="*[name()='button']">
</xsl:template>

<xsl:template match="*[name()='input'][@type='button']">
</xsl:template>

<!-- ======================================================================	-->
<!-- Rule to output a disabled xsl:when if it will be show ghosted text		-->

<xsl:template match="ixsl:when[.//ixsl:attribute/@name[. = 'xd:ghosted']]">
	<out:when test="false() and {@test}">
		<xsl:apply-templates select="* | @*[name() != 'test'] | text()" />
	</out:when>
</xsl:template>

<!-- ======================================================================	-->
<!-- Rule for a non-bound SELECT element w/ a VALUE or an OPTION SELECTED	-->

<xsl:template match="*[0 = msxsl:string-compare(name(), 'select', '', 'i')]">

	<!-- See if there's a child OPTION tag with SELECTED attribute -->
	<xsl:variable name="selected" select=".//*[0 = msxsl:string-compare(name(), 'option', '', 'i')][@*[0 = msxsl:string-compare(name(), 'selected', '', 'i')]]" />

	<!-- Also see if there's a VALUE on the SELECT to fall back on if OPTION SELECTED isn't present -->

	<xsl:variable name="value" select="@*[0 = msxsl:string-compare(name(), 'value', '', 'i')]" />

	<xsl:choose>
		<xsl:when test="count($selected) > 0">
			<U><SPAN>
				<xsl:apply-templates select="@*" />
				<xsl:value-of select="$selected" />
			</SPAN></U>
		</xsl:when>

		<xsl:when test="count($value) > 0">
			<U><SPAN>
				<xsl:apply-templates select="@*" />
				<xsl:value-of select="$value" />
			</SPAN></U>
		</xsl:when>

		<xsl:otherwise>
			<xsl:copy>
				<xsl:apply-templates select="*|@*|text()" />
			</xsl:copy>
		</xsl:otherwise>
	</xsl:choose>

</xsl:template>

<!-- ======================================================================	-->
<!-- Rule for a bound SELECT element										-->

<xsl:template match="*[0 = msxsl:string-compare(name(), 'select', '', 'i')][ixsl:attribute/ixsl:value-of]">

	<xsl:variable name="options" select=".//*[0 = msxsl:string-compare(name(), 'option', '', 'i')]" />

	<xsl:choose>
		<!-- check to see if there are OPTION tags under this SELECT element -->
		
		<xsl:when test="count($options) &gt; 0 and ixsl:choose/ixsl:when/ixsl:for-each and ixsl:choose/ixsl:when/ixsl:variable">
			<!-- AuxDom populated SELECT element; try to create XSL for underlining appropriately -->
			
			<U>
				<SPAN>
					<out:value-of select="{ixsl:choose/ixsl:when/ixsl:variable/@select}" />
				</SPAN>
			</U>
		</xsl:when>
		
		<xsl:when test="count($options) &gt; 0">
			<U>
				<SPAN>
					<xsl:apply-templates select="@*" />

					<xsl:variable name="xpath" select="ixsl:attribute/ixsl:value-of/@select" />

					<out:choose>
						<xsl:for-each select="$options" >
							<out:when>
								<xsl:variable name="value" select="@*[0 = msxsl:string-compare(name(), 'value', '', 'i')]" />
								<xsl:attribute name="test"><xsl:text>&quot;</xsl:text><xsl:value-of select="$value"/><xsl:text>&quot; = </xsl:text><xsl:value-of select="$xpath" /></xsl:attribute>
								<xsl:value-of select="child::text()" />
							</out:when>
						</xsl:for-each>

						<!-- Add an OTHERWISE clause to select the first should any other above not match -->
						<!-- the intention is to simulate a SELECT element's behvior in IE -->

						<out:otherwise>
							<xsl:value-of select="$options[1]/child::text()" />
						</out:otherwise>
					</out:choose>
				</SPAN>
			</U>
		</xsl:when>

		<xsl:otherwise>

			<!-- No OPTION tags, just pass through the contents of this SELECT since    -->
			<!-- special logic is most likely involved and it is difficult to correctly -->
			<!-- transform this portion of the XSL without error.                       -->
			
			<xsl:copy>
				<xsl:apply-templates select="*|@*|text()"/>
			</xsl:copy>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<!-- ======================================================================	-->
<!-- Additional rules and elements to add to the main stylesheet body		-->

<xsl:template match="ixsl:stylesheet">
	<xsl:copy>
		<xsl:apply-templates select="@*|node()"/>

		<!-- Rich text (copy-of content) rules: avoid copying over		-->
		<!-- elements that can't be rendered (like inline images) or	-->
		<!-- that shouldn't be there (like buttons)						-->
		
		<out:template match="@*|node()" mode="RichCopyExcludeEncodedImages">
			<out:copy>
				<out:apply-templates select="@*|node()" mode="RichCopyExcludeEncodedImages" />
			</out:copy>
		</out:template>

		<out:template match="*[@*[name()='xd:inline']]" mode="RichCopyExcludeEncodedImages" >
		</out:template>
		
		<out:template match="*[name()='button']" mode="RichCopyExcludeEncodedImages" >
		</out:template>

		<out:template match="*[name()='input'][@type='button']" mode="RichCopyExcludeEncodedImages" >
		</out:template>

	<outmsxsl:script language="VBScript" implements-prefix="xdFormatting">
	<xsl:text>
	<![CDATA[
	' ------------------------------------------------------------------------
	' Formatting replacement script
	' ------------------------------------------------------------------------
	'
	' Constants for dealing with Tristate arguments (FormatNumber)
	
	Const TristateTrue = -1
	Const TristateFalse = 0
	Const TristateUseDefault = -2

	' ------------------------------------------------------------------------
	' ParseFormattingArgs
	'	Input	String	Formatting argument list (passed into formatString())
	'
	'	Output	Object	Dictionary instance containing the argument name /
	'					value pairs.
	
	Function ParseFormattingArgs(sFormatArgs)
		Dim oDict
		Dim rgsArgs
		Dim sArg
		Dim iColon
		Dim csArg
		
		Set oDict = CreateObject("Scripting.Dictionary")

		' Split initially by the semicolon and then by the colon to find the
		' name value pairs within the formatting argument string.
		
		rgsArgs = Split(sFormatArgs, ";")

		For Each sArg In rgsArgs
			iColon = InStr(sArg, ":")
			If iColon <> 0 Then
				csArg = Len(sArg)
				oDict.Add Left(sArg, iColon - 1), Right(sArg, csArg - iColon)
			End If
		Next

		Set ParseFormattingArgs = oDict
	End Function

	' ------------------------------------------------------------------------
	' PrepareTimeFormat
	'	Input	String	An ISO-8601 formate date / time / date-time
	'
	'	Output	String	A fixed up version suitable for date parsing.
	
	Function PrepareTimeFormat(sTime)
		Dim	regEx
		Dim sDateTime

		sDateTime = sTime
		Set regEx = New RegExp

		' Remove the Z timezone qualifier, if present
		regEx.Pattern = "Z.*"
		sDateTime = regEx.Replace(sDateTime, "")
		
		' Remove the timezone +/- value, if present
		regEx.Pattern = "(:[0-9][0-9])([+-])(.*)"
		sDateTime = regEx.Replace(sDateTime, "$1")

		' Remove the T date / time separator, if present
		
		regEx.Pattern = "T"
		sDateTime = regEx.Replace(sDateTime, " ") 

		PrepareTimeFormat = sDateTime
	End Function

	' ------------------------------------------------------------------------
	' formatAsDate
	'	Input	String	An ISO-8601 formate date / time / date-time
	'			String	Formatting argument list
	'
	'	Output	String	A simple formatted version (either long or short)
	
	Function formatAsDate(sDate, sFormatArgs)
		Dim sPreppedTime
		Dim	iDateFormat
		Dim oDict
		
		' iDateFormat can be:
		'	0 = General Date,	(default)
		'	1 = Long Date,
		'	2 = Short Date
		
		iDateFormat = 0

		' Look for either "Short Date" or "Long Date" formatting
		
		Set oDict = ParseFormattingArgs(sFormatArgs)

		If oDict.Exists("dateFormat") Then
			sValue = oDict.Item("dateFormat")
			If sValue = "Long Date" Then iDateFormat = 1
			If sValue = "Short Date" Then iDateFormat = 2
		End If
		
		sPreppedTime = PrepareTimeFormat(sDate)

		' Call into VBScript FormatDateTime() function
		formatAsDate = FormatDateTime(sPreppedTime, iDateFormat)
	End Function

	' ------------------------------------------------------------------------
	' formatAsTime
	'	Input	String	An ISO-8601 formate date / time / date-time
	'			String	Formatting argument list
	'
	'	Output	String	A simple formatted version (either long or short)
	
	Function formatAsTime(sTime, sFormatArgs)
		Dim sPreppedTime
		Dim	iTimeFormat
		Dim oDict
		
		' iTimeFormat can be:
		'	3 = Long Time,	(default)
		'	4 = Short Time	(24 hour)

		iTimeFormat = 3

		' Look for timeFormat and then peek into it for a 24-hour
		' formatting string
		
		Set oDict = ParseFormattingArgs(sFormatArgs)

		If oDict.Exists("timeFormat") Then
			sValue = oDict.Item("timeFormat")
			If InStr(sValue, "H:") <> 0 Then iTimeFormat = 4
		End If

		sPreppedTime = PrepareTimeFormat(sTime)

		' Call into VBScript FormatDateTime() function
		formatAsTime = FormatDateTime(sPreppedTime, iTimeFormat)
	End Function

	' ------------------------------------------------------------------------
	' formatAsDateTime
	'	Input	String	An ISO-8601 formate date / time / date-time
	'			String	Formatting argument list (ignored)
	'
	'	Output	String	A simple formatted version
	
	Function formatAsDateTime(sDateTime, sFormatArgs)
		Dim sPreppedTime

		' Don't bother consulting sFormatArgs - using FormatDateTime there's
		' only one kind of formatting that can be done to format both the
		' date and time portion
		
		sPreppedTime = PrepareTimeFormat(sDateTime)
		
		' Call into VBScript FormatDateTime() function
		formatAsDateTime = FormatDateTime(sPreppedTime, 0)
	End Function

	' ------------------------------------------------------------------------
	' formatAsNumber
	'	Input	String	Text value of a numeric
	'			String	Formatting argument list
	'
	'	Output	String	A simple formatted version
	
	Function formatAsNumber(sNumber, sFormatArgs)
		Dim DecimalPlaces
		Dim IncLeadingZero
		Dim UseParenthesis
		Dim GroupDigits
		Dim oDict
		Dim sValue

		' Within the sFormatArgs, we can look for:
		'
		'	Description			name:value				Action
		'
		'	Fractional digits:	numDigits:0-9 or auto	-1 or the number 0-9
		'	Leading zero?		leadingZero:0|1			TristateTrue if 1, False if 0
		'	Negative: - or ()?	negativeOrder:0-4		TristateTrue if 0
		'	Number grouping?	grouping:0-9 or 32		TristateFalse if 0

		' Set defaulits
		
		DecimalPlaces  = -1
		IncLeadingZero = TristateUseDefault
		UseParenthesis = TristateUseDefault
		GroupDigits    = TristateUseDefault

		Set oDict = ParseFormattingArgs(sFormatArgs)
		
		If oDict.Exists("numDigits") Then
			sValue = oDict.Item("numDigits")
			If sValue <> "auto" Then DecimalPlaces = CInt(sValue)
		End If

		If oDict.Exists("leadingZero") Then
			sValue = oDict.Item("leadingZero")
			If sValue = "1" Then IncLeadingZero = TristateTrue
		End If
		
		If oDict.Exists("negativeOrder") Then
			sValue = oDict.Item("negativeOrder")
			If sValue = "0" Then UseParenthesis = TristateTrue
		End If
		
		If oDict.Exists("grouping") Then
			sValue = oDict.Item("grouping")
			If sValue = "0" Then GroupDigits = TristateFalse
		End If

		' Call into VBScript FormatNumber() function
		formatAsNumber = FormatNumber(sNumber, DecimalPlaces, IncLeadingZero, UseParenthesis, GroupDigits)
	End Function

	' ------------------------------------------------------------------------
	' formatString - OM replacement call
	'	Input	nodes	Nodes set to format (just grab the first element)
	'			String	Type of the element, as far as formatting should be
	'					concerned.
	'			String	Formatting argument list
	'
	'	Output	String	A simple formatted version
	
	Function formatString(nodeSet, sType, sFormatArgs)
		Dim sNodeText

		On Error Resume Next
		
		sNodeText = nodeSet(0).text
		formatString = sNodeText
		
		If sNodeText = "" Then
			formatString = ""
		Else
			If sType = "date" Then
				formatString = formatAsDate(sNodeText, sFormatArgs)
			ElseIf sType = "number" Or sType = "currency" Then
				formatString = formatAsNumber(sNodeText, sFormatArgs)
			ElseIf sType = "time" Then
				formatString = formatAsTime(sNodeText, sFormatArgs)
			ElseIf sType = "datetime" Then
				formatString = formatAsDateTime(sNodeText, sFormatArgs)
			Else
				' Not handled, just return the node's value
				formatString = sNodeText
			End If
		End If

	End Function
	]]>
	</xsl:text>
	</outmsxsl:script>

	<outmsxsl:script language="JScript" implements-prefix="xd">
	<xsl:text>
	<![CDATA[
	// -----------------------------------------------------------------------
	// getXSLTDocURLBase
	//	Input	nodes	nodeset containing the root element of the XSLT doc
	//
	//	Output	String	URL of the view's XSLT sheet (or blank on error)
	
	function getXSLTDocURLBase(xsltRootNodeList)
	{
		try
			{
			return xsltRootNodeList.item(0).url;
			}
		catch (exception)
			{
			return "";
			}
	}
	]]>
	</xsl:text>
	</outmsxsl:script>

	</xsl:copy>
</xsl:template>

</xsl:stylesheet>

