﻿Imports	System
Imports	Microsoft.Office.Interop.InfoPath.SemiTrust
Imports Microsoft.VisualBasic

' Office integration attribute. Identifies the startup class for the form. Do not
' modify.
<Assembly: System.ComponentModel.DescriptionAttribute("InfoPathStartupClass, Version=1.0, Class=SimpleScriptsNET.SimpleScriptsNET")>


Namespace SimpleScriptsNET


	' The namespace prefixes defined in this attribute must remain synchronized with
	' those in the form definition file (.xsf).
	<InfoPathNamespace("xmlns:my='http://schemas.microsoft.com/office/infopath/2003/myXSD/2004-04-21T10-58-43'")>	_
	Public Class SimpleScriptsNET


		Private	thisXDocument As XDocument
		Private	thisApplication	As Application


		Public Sub _Startup(app	As Application, doc As XDocument)
			thisXDocument = doc
			thisApplication	= app

            ' Tu można wprowadzić dodatkowy kod inicjujący.
		End Sub


		Public Sub _Shutdown()
		End	Sub

        <InfoPathEventHandler(MatchPath:="cmdMessage", EventType:=InfoPathEventType.OnClick)> _
        Public Sub cmdMessage_OnClick(ByVal e As DocActionEvent)
            thisXDocument.UI.Alert("To jest komunikat do wyświetlenia.")
        End Sub

        <InfoPathEventHandler(MatchPath:="cmdSave", EventType:=InfoPathEventType.OnClick)> _
        Public Sub cmdSave_OnClick(ByVal e As DocActionEvent)
            thisXDocument.Save()
        End Sub

        <InfoPathEventHandler(MatchPath:="cmdSend", EventType:=InfoPathEventType.OnClick)> _
        Public Sub cmdSend_OnClick(ByVal e As DocActionEvent)
            thisXDocument.UI.ShowMailItem("ktos@przyklad.com", "", "", "Temat", "Treść wiadomości.")
            ' Inny sposób.
            'thisApplication.ActiveWindow.MailEnvelope.To = "ktos@przyklad.com"
            'thisApplication.ActiveWindow.MailEnvelope.Subject = "Temat"
            'thisApplication.ActiveWindow.MailEnvelope.Visible = True
        End Sub

        <InfoPathEventHandler(MatchPath:="cmdQuit", EventType:=InfoPathEventType.OnClick)> _
        Public Sub cmdQuit_OnClick(ByVal e As DocActionEvent)
            thisApplication.Quit(True)
        End Sub

        <InfoPathEventHandler(MatchPath:="cmdXML", EventType:=InfoPathEventType.OnClick)> _
        Public Sub cmdXML_OnClick(ByVal e As DocActionEvent)
            thisXDocument.UI.Alert(thisXDocument.DOM.xml)
        End Sub

        <InfoPathEventHandler(MatchPath:="cmdValue", EventType:=InfoPathEventType.OnClick)> _
        Public Sub cmdValue_OnClick(ByVal e As DocActionEvent)
            Dim var1
            var1 = thisXDocument.DOM.getElementsByTagName("my:field1").Item(0).text
            thisXDocument.UI.Alert(var1)
        End Sub


        <InfoPathEventHandler(MatchPath:="cmdHTML", EventType:=InfoPathEventType.OnClick)> _
        Public Sub cmdHTML_OnClick(ByVal e As DocActionEvent)
            Dim result
            result = thisXDocument.UI.ShowModalDialog("msg.htm", "status:no;help:no;resizable:yes;dialogHeight:400px;dialogWidth:600px", 200, 300, 200, 200)
        End Sub

        <InfoPathEventHandler(MatchPath:="cmdNew", EventType:=InfoPathEventType.OnClick)> _
        Public Sub cmdNew_OnClick(ByVal e As DocActionEvent)
            ' Tutaj wpisz swój kod.

        End Sub

        <InfoPathEventHandler(MatchPath:="cmdNew2", EventType:=InfoPathEventType.OnClick)> _
        Public Sub cmdNew2_OnClick(ByVal e As DocActionEvent)
            ' Tutaj wpisz swój kod.

        End Sub

        <InfoPathEventHandler(MatchPath:="cmdOpen", EventType:=InfoPathEventType.OnClick)> _
        Public Sub cmdOpen_OnClick(ByVal e As DocActionEvent)
            ' Tutaj wpisz swój kod.

        End Sub
    End Class


End	Namespace
