Imports System.Windows.Forms
Imports Office = Microsoft.Office.Core
Imports Excel = Microsoft.Office.Interop.Excel
Imports MSForms = Microsoft.Vbe.Interop.Forms

' Atrybut integracji z Office. Identyfikuje klas startow dla skoroszytu. Nie modyfikowa.
<Assembly: System.ComponentModel.DescriptionAttribute("OfficeStartupClass, Version=1.0, Class=ExcelNetApp.OfficeCodeBehind")>

Public Class OfficeCodeBehind 

    Friend WithEvents ThisWorkbook As Excel.Workbook
    Friend WithEvents ThisApplication As Excel.Application
    Friend WithEvents ActiveWorksheet As Excel.Worksheet
    Friend WithEvents cmdReformat As MSForms.CommandButton
    Friend WithEvents cmdForm As MSForms.CommandButton
    Friend WithEvents cmdSend As MSForms.CommandButton
    Friend chkModal As MSForms.CheckBox

#Region "Generated initialization code"

    ' Default constructor.
    Public Sub New()
    End Sub

    ' Required procedure. Do not modify.
    Public Sub _Startup(ByVal application As Object, ByVal workbook As Object)
        ThisApplication = CType(application, Excel.Application)
        ThisWorkbook = CType(workbook, Excel.Workbook)
    End Sub

    ' Required procedure. Do not modify.
    Public Sub _Shutdown()
        ThisApplication = Nothing
        ThisWorkbook = Nothing
    End Sub

    ' Returns the control with the specified name on ThisWorkbook's active worksheet.
    Overloads Function FindControl(ByVal name As String) As Object
        Return FindControl(name, CType(ThisWorkbook.ActiveSheet, Excel.Worksheet))
    End Function

    ' Returns the control with the specified name on the specified worksheet.
    Overloads Function FindControl(ByVal name As String, ByVal sheet As Excel.Worksheet) As Object
        Dim theObject As Excel.OLEObject
        Try
            theObject = CType(sheet.OLEObjects(name), Excel.OLEObject)
            Return theObject.Object
        Catch Ex As Exception
            ' Report the exception.
            Debug.Fail(Ex.Message, Ex.ToString)
        End Try
        Return Nothing
    End Function
#End Region

    ' Wywoywana podczas otwierania skoroszytu.
    Private Sub ThisWorkbook_Open() Handles ThisWorkbook.Open
        ' Uaktywnienie arkusza, w ktrym znaleziono element sterujcy.
        ThisApplication.Sheets("Zdarzenia").activate()
        ' Ustawienie obiektu ActiveSheet
        If ThisApplication.ActiveSheet.Type = Excel.XlSheetType.xlWorksheet Then _
           ActiveWorksheet = CType(ThisApplication.ActiveSheet, Excel.Worksheet)
        ' Wyszukanie elementu sterujcego w arkuszu i dowizanie si do jego zdarze.
        cmdReformat = CType(FindControl("cmdReformat"), MSForms.CommandButton)
        cmdForm = CType(FindControl("cmdForm", ThisWorkbook.Sheets("Formularze")), MSForms.CommandButton)
        cmdSend = CType(FindControl("cmdSend", ThisWorkbook.Sheets("Wysyka")), MSForms.CommandButton)
        chkModal = CType(FindControl("chkModal", ThisWorkbook.Sheets("Formularze")), MSForms.CheckBox)
    End Sub

    ' Wywoywana przed zamkniciem skoroszytu. Zwrmy uwag, e ta metoda
    ' moe by wywoywana wiele razy, a ustawiona warto Cancel
    ' moe by zignorowana, jeli nastpi ingerencja innego kodu bd uytkownika.
    ' Cancel ma warto False, jeli zachodzi zdarzenie. Jeli procedura obsugi zdarzenia
    ' ustawi j na True, dokument nie zostanie zamknity po zakoczeniu dziaania procedury.
    Private Sub ThisWorkbook_BeforeClose(ByRef Cancel As Boolean) Handles ThisWorkbook.BeforeClose
        Cancel = False
    End Sub

    Private Sub ThisWorkbook_SheetActivate(ByVal Sh As Object) Handles ThisWorkbook.SheetActivate
        If Sh.Type = Excel.XlSheetType.xlWorksheet Then _
          ActiveWorksheet = CType(Sh, Excel.Worksheet)
    End Sub

    ' Wykorzystuje schowek i wasno importu tekstu w Excelu w celu zinterpretowania 
    ' mieszanej treci XML jako formatowania HTML.
    Friend Sub ReformatHTML(ByVal ws As Excel.Worksheet)
        For Each cel As Excel.Range In ws.UsedRange
            'Jeli w komrce jest tekst.
            If InStr(cel.Text, "<") Then
                Clipboard.SetDataObject("<html>" & cel.Value & "</html>")
                cel.PasteSpecial()
            End If
        Next
    End Sub

    Private Sub ActiveWorksheet_Change(ByVal Target As Excel.Range) _
      Handles ActiveWorksheet.Change
        ' Podniesienie do kwadratu wartoci wprowadzonej w komrce A1  i wywietlenie wyniku w komrce A2.
        If Target.Address = "$A$1" Then
            ActiveWorksheet.Range("A2").Value = Target.Value ^ 2
        End If
    End Sub

    Private Sub cmdReformat_Click() Handles cmdReformat.Click
        For Each cel As Excel.Range In ThisWorkbook.ActiveSheet.UsedRange
            ' Jeli zakres rng zawiera tekst.
            If InStr(cel.Text, "<") Then
                Clipboard.SetDataObject("<html>" & cel.Value & "</html>")
                cel.PasteSpecial()
            End If
        Next
    End Sub

    Private Sub cmdSquare_Click() Handles cmdForm.Click
        ' Utworzenie nowego obiektu formularza.
        Dim frm As New SimpleForm(Me)
        If chkModal.Value Then
            ' Wywietlenie formularza w trybie modalnym (Excel czeka na jego zamknicie).
            frm.ShowDialog()
        Else
            ' Wywietlenie formularza w trybie niemodalnym i zachowanie go na pierwszym planie.
            frm.TopMost = True
            frm.Show()
        End If
    End Sub


    Private Sub cmdSend_Click() Handles cmdSend.Click
        Dim _AssemblyName0 As String, _AssemblyLocation0 As String, name As String
        ' Zapisanie ustawie waciwoci uytkownika.
        _AssemblyName0 = ThisWorkbook.CustomDocumentProperties("_AssemblyName0").Value
        _AssemblyLocation0 = ThisWorkbook.CustomDocumentProperties("_AssemblyLocation0").Value
        ' Wyczyszczenie waciwoci uytkownika.
        ThisWorkbook.CustomDocumentProperties("_AssemblyName0").Value = ""
        ThisWorkbook.CustomDocumentProperties("_AssemblyLocation0").Value = ""
        ' Zapisanie biecej nazwy.
        name = ThisWorkbook.FullName
        ' Zapisanie kopii skoroszytu (bez waciwoci).
        ThisWorkbook.SaveAs("Copy of " & ThisWorkbook.Name)
        ' Wysanie skoroszytu.
        ThisWorkbook.SendMail("ExcelDemo@hotmail.com", ThisWorkbook.Name)
        ' Przywrcenie waciwoci i nazwy
        ThisWorkbook.CustomDocumentProperties("_AssemblyName0").Value = _AssemblyName0
        ThisWorkbook.CustomDocumentProperties("_AssemblyLocation0").Value = _AssemblyLocation0
        ThisWorkbook.SaveAs(name)
    End Sub

End Class

