Imports Excel = Microsoft.Office.Interop.Excel

Public Class SimpleForm
    Inherits System.Windows.Forms.Form

    Dim xlCode As OfficeCodeBehind

#Region " Windows Form Designer generated code "

    Public Sub New(ByVal target As OfficeCodeBehind)
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        ' Pobranie klasy OfficeCodeBehind, ktra utworzya ten formularz
        ' (w celu zwrcenia odpowiedzi do Excela).
        xlCode = target
    End Sub


    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents cmdSquare As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.cmdSquare = New System.Windows.Forms.Button
        Me.SuspendLayout()
        '
        'cmdSquare
        '
        Me.cmdSquare.Location = New System.Drawing.Point(24, 32)
        Me.cmdSquare.Name = "cmdSquare"
        Me.cmdSquare.Size = New System.Drawing.Size(120, 23)
        Me.cmdSquare.TabIndex = 0
        Me.cmdSquare.Text = "Podnie do kwadratu"
        '
        'SimpleForm
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(160, 85)
        Me.Controls.Add(Me.cmdSquare)
        Me.Name = "SimpleForm"
        Me.Text = "Prosty formularz"
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub cmdSquare_Click(ByVal sender As System.Object, _
      ByVal e As System.EventArgs) Handles cmdSquare.Click
        ' Zamknicie formularza, jeli wykonanie metody SquareCells powiedzie si.
        If SquareCells() Then Me.Close()
    End Sub

    Private Function SquareCells() As Boolean
        Try
            ' Dla kadej komrki w wykorzystywanym zakresie aktywnego arkusza...
            For Each cel As Excel.Range In xlCode.ThisWorkbook.ActiveSheet.UsedRange
                ' Podniesienie wartoci do kwadratu.
                cel.Value = cel.Value ^ 2
            Next
        Catch ex As System.Runtime.InteropServices.COMException
            ' Co si wydarzyo w Excelu.
            Debug.Fail(ex.Source & " " & Hex(ex.errorcode), ex.Message)
            Return False
        Catch ex As Exception
            ' Co si wydarzyo w .NET (wywietlenie bdu podczas debugowania)
            Debug.Fail(ex.Source, ex.Message)
            Return False
        End Try
        ' Sukces.
        Return True
    End Function

    Private Function SquareCells2() As Boolean
        Try
            ' Pobranie wykorzystywanego zakresu z pierwszego arkusza aktywnego skoroszytu.
            Dim rng As Excel.Range, cell As Excel.Range, ws As Excel.Worksheet
            ws = xlCode.ActiveWorksheet
            rng = ws.UsedRange
            ' Podniesienie wartoci do kwadratu.
            For col As Integer = 1 To rng.Columns.Count
                For row As Integer = 1 To rng.Rows.Count
                    cell = ws.Cells(row, col)
                    cell.Value = cell.Value ^ 2
                Next
            Next
        Catch ex As System.Runtime.InteropServices.COMException
            ' Co si wydarzyo w Excelu.
            Debug.Fail(ex.Source & " " & Hex(ex.errorcode), ex.Message)
            Return False
        Catch ex As Exception
            ' Co si wydarzyo w .NET (wywietlenie bdu podczas debugowania)
            Debug.Fail(ex.Source, ex.Message)
            Return False
        End Try
        ' Sukces.
        Return True
    End Function

End Class
