Imports System.Windows.Forms
Imports Office = Microsoft.Office.Core
Imports Excel = Microsoft.Office.Interop.Excel
Imports MSForms = Microsoft.Vbe.Interop.Forms

' Office integration attribute. Identifies the startup class for the workbook. Do not modify.
<Assembly: System.ComponentModel.DescriptionAttribute("OfficeStartupClass, Version=1.0, Class=ExcelNetApp.OfficeCodeBehind")>

Public Class OfficeCodeBehind 

    Friend WithEvents ThisWorkbook As Excel.Workbook
    Friend WithEvents ThisApplication As Excel.Application
    Friend WithEvents ActiveWorksheet As Excel.Worksheet
    Friend WithEvents cmdReformat As MSForms.CommandButton

#Region "Generated initialization code"

    ' Default constructor.
    Public Sub New()
    End Sub

    ' Required procedure. Do not modify.
    Public Sub _Startup(ByVal application As Object, ByVal workbook As Object)
        ThisApplication = CType(application, Excel.Application)
        ThisWorkbook = CType(workbook, Excel.Workbook)

    
    End Sub

    ' Required procedure. Do not modify.
    Public Sub _Shutdown()
        ThisApplication = Nothing
        ThisWorkbook = Nothing
    End Sub

    ' Returns the control with the specified name on ThisWorkbook's active worksheet.
    Overloads Function FindControl(ByVal name As String) As Object
        Return FindControl(name, CType(ThisWorkbook.ActiveSheet, Excel.Worksheet))
    End Function

    ' Returns the control with the specified name on the specified worksheet.
    Overloads Function FindControl(ByVal name As String, ByVal sheet As Excel.Worksheet) As Object
        Dim theObject As Excel.OLEObject
        Try
            theObject = CType(sheet.OLEObjects(name), Excel.OLEObject)
            Return theObject.Object
        Catch Ex As Exception
            ' Report the exception.
            Debug.Fail(Ex.Message, Ex.ToString)
        End Try
        Return Nothing
    End Function
#End Region

    ' Called when the workbook is opened.
    Private Sub ThisWorkbook_Open() Handles ThisWorkbook.Open
        ' Activate the worksheet the control is found on.
        ThisApplication.Sheets("Sheet1").activate()
        ' Set the ActiveSheet object
        If ThisApplication.ActiveSheet.Type = Excel.XlSheetType.xlWorksheet Then _
           ActiveWorksheet = CType(ThisApplication.ActiveSheet, Excel.Worksheet)
        ' Find the control on the sheet and hook up its events.
        cmdReformat = CType(FindControl("cmdReformat"), _
          MSForms.CommandButton)
    End Sub

    Private Sub ThisWorkbook_SheetActivate(ByVal Sh As Object) _
      Handles ThisWorkbook.SheetActivate
        ' Change active worksheet
        If Sh.Type = Excel.XlSheetType.xlWorksheet Then _
          ActiveWorksheet = CType(Sh, Excel.Worksheet)
    End Sub

    Private Sub ActiveWorksheet_Change(ByVal Target As Excel.Range) _
      Handles ActiveWorksheet.Change
        ' Square value entered in range A1 and display in A2.
        If Target.Address = "$A$1" Then
            ActiveWorksheet.Range("A2").Value = Target.Value ^ 2
        End If
    End Sub

    Private Sub cmdReformat_Click() Handles cmdReformat.Click
        ReformatHTML(ActiveWorksheet)
    End Sub

    ' Called before the workbook is closed. Note that this method
    ' might be called multiple times and the value assigned to Cancel
    ' might be ignored if other code or the user intervenes.
    ' Cancel is False when the event occurs. If the event procedure
    ' sets this to True, the document does not close when the procedure is finished.
    Private Sub ThisWorkbook_BeforeClose(ByRef Cancel As Boolean) Handles ThisWorkbook.BeforeClose
        Cancel = False
    End Sub

End Class
