Imports Microsoft.Office.Interop
Imports Microsoft.Win32

Public Class Form1
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()
        GetExcelVer()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents cmdStartExcel As System.Windows.Forms.Button
    Friend WithEvents cmdQuitExcel As System.Windows.Forms.Button
    Friend WithEvents cmdCauseError As System.Windows.Forms.Button
    Friend WithEvents cmdChangeCells As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.cmdStartExcel = New System.Windows.Forms.Button
        Me.cmdQuitExcel = New System.Windows.Forms.Button
        Me.cmdCauseError = New System.Windows.Forms.Button
        Me.cmdChangeCells = New System.Windows.Forms.Button
        Me.SuspendLayout()
        '
        'cmdStartExcel
        '
        Me.cmdStartExcel.Location = New System.Drawing.Point(16, 40)
        Me.cmdStartExcel.Name = "cmdStartExcel"
        Me.cmdStartExcel.Size = New System.Drawing.Size(104, 23)
        Me.cmdStartExcel.TabIndex = 0
        Me.cmdStartExcel.Text = "Uruchom Excela"
        '
        'cmdQuitExcel
        '
        Me.cmdQuitExcel.Location = New System.Drawing.Point(16, 152)
        Me.cmdQuitExcel.Name = "cmdQuitExcel"
        Me.cmdQuitExcel.Size = New System.Drawing.Size(104, 24)
        Me.cmdQuitExcel.TabIndex = 1
        Me.cmdQuitExcel.Text = "Zakocz Excela"
        '
        'cmdCauseError
        '
        Me.cmdCauseError.Location = New System.Drawing.Point(16, 72)
        Me.cmdCauseError.Name = "cmdCauseError"
        Me.cmdCauseError.Size = New System.Drawing.Size(104, 32)
        Me.cmdCauseError.TabIndex = 2
        Me.cmdCauseError.Text = "Spowoduj bd"
        '
        'cmdChangeCells
        '
        Me.cmdChangeCells.Location = New System.Drawing.Point(16, 112)
        Me.cmdChangeCells.Name = "cmdChangeCells"
        Me.cmdChangeCells.Size = New System.Drawing.Size(104, 32)
        Me.cmdChangeCells.TabIndex = 3
        Me.cmdChangeCells.Text = "Modyfikuj komrki"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(292, 273)
        Me.Controls.Add(Me.cmdChangeCells)
        Me.Controls.Add(Me.cmdCauseError)
        Me.Controls.Add(Me.cmdQuitExcel)
        Me.Controls.Add(Me.cmdStartExcel)
        Me.Name = "Form1"
        Me.Text = "Formularz1"
        Me.ResumeLayout(False)

    End Sub

#End Region

    ' .NET Windows form code
    Dim WithEvents m_xl As Excel.Application
    Dim WithEvents m_ws As Excel.Worksheet

    Private Sub cmdStartExcel_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles cmdStartExcel.Click
        ' Utworzenie nowego egzemplarza obiektu, jeli go nie zainicjowano.
        If IsNothing(m_xl) Then _
            m_xl = New Excel.Application
        ' Wywietlenie Excela.
        m_xl.Visible = True
        Dim wb As Excel.Workbook, rng As Excel.Range
        ' Utworzenie nowego skoroszytu.
        wb = m_xl.Workbooks.Add()
        ' Wprowadzenie przykadowych danych
        For i As Integer = 1 To 10
            rng = wb.Worksheets(1).Cells(1, i)
            rng.Value = 2 ^ i
        Next
        ' Powizanie arkusza ze zdarzeniami z wykorzystaniem zmiennej poziomu klasy.
        m_ws = wb.Worksheets(1)
    End Sub

    Private Sub cmdQuitExcel_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles cmdQuitExcel.Click
        ' Zamknicie aplikacji Excela.
        m_xl.Quit()
        ' Ustawienie adresu obiektu na Nothing.
        Debug.Write(IsNothing(m_xl))
        m_xl = Nothing
        ' Wymuszone odmiecanie.
        System.GC.Collect()
    End Sub

    Private Sub m_ws_Change(ByVal Target As Microsoft.Office.Interop.Excel.Range) _
      Handles m_ws.Change
        If Target.Address = "$A$2" Then
            Dim NetStr As New NetForExcel.NetString
            m_ws.Range("B2").Value = NetStr.Sort(Target.Value)
        End If
    End Sub

    Private Sub cmdCauseErrors_Click(ByVal sender As System.Object, _
      ByVal e As System.EventArgs) Handles cmdCauseError.Click
        ' Spowodowanie oglnego bdu Excela. 
        Try
            ' Tena arkusz (9) nie istnieje.
            m_xl.ActiveWorkbook.Sheets(9).Range("B2").value = 42
        Catch ex As System.Runtime.InteropServices.COMException
            Debug.WriteLine(ex.Source & " " & ex.Message & " " & Hex(ex.errorcode) _
              & " " & GetErrCode(ex.ErrorCode))
        End Try
        ' Spowodowanie bdu aplikacji w Excelu.
        Try
            ' To jest nieprawidowa warto w komrce.
            m_ws.Range("A3").Value = "=To nie dziaa."
        Catch ex As System.Runtime.InteropServices.COMException
            Debug.WriteLine(ex.Source & " " & ex.Message & " " & Hex(ex.errorcode) _
              & " " & GetErrCode(ex.ErrorCode))
        End Try
        ' Spowodowanie oglnego bdu Excela (nie zawiera kodu HRESULT!)
        Try
            m_xl.Workbooks.Open("nieistnieje.xls")
        Catch ex As System.Runtime.InteropServices.COMException
            Debug.WriteLine(ex.Source & " " & ex.Message & " " & Hex(ex.errorcode) _
             & " " & GetErrCode(ex.ErrorCode))
        End Try
        ' Spowodowanie bdu Interop.
        Try
            ' Aby zobaczy bd ustaw tu puapk (breakpoint) i wyedytuj komrk w Excelu.
            m_xl.ActiveWorkbook.Sheets(1).Range("B3").select()
            ' Nie mona zmodyfikowa komrki w czasie, gdy jest w trybie edycji w Excelu.
            m_xl.ActiveWorkbook.Sheets(1).Range("B2").value = 42
        Catch ex As System.Runtime.InteropServices.COMException
            Debug.WriteLine(ex.Source & " " & ex.Message & " " & Hex(ex.errorcode) _
              & " " & GetErrCode(ex.ErrorCode))
        End Try
    End Sub

    ' Interpretuje kod HRESULT.
    Function GetFacility(ByVal hresult As Integer) As String
        ' Pierwszy bit kodu HRESULT oznacza istotno bdu -- ma warto 1 w
        ' przypadku bdu i 0 w przypadku powodzenia operacji. W tym przykadzie 
        ' obsugujemy bdy, a zatem mona zaoy, e pierwszy bit ma warto 1.
        ' W zapisie szesnastkowym kodu HRESULT wystpuje zatem "8" (na przykad: &h800A03EC).
        Dim fac As String
        fac = Hex(hresult / &H10000 And &HFFFF)
        Select Case fac
            Case "0"
                Return "Success" ' HRESULT zwrci sukces.
            Case "8002", "800A", "8004"
                Return "IDispatch" ' Zazwyczaj oznacza to Excela, Worda, etc.
            Case "8001"
                Return "RPC" ' Zazwyczaj oznacza to bd wsppracy (interop).
            Case "8003"
                Return "Pami" ' Mniej znaczce 16 bitw kodu HRESULT to kod bdu pliku DOS.
            Case "8007"
                Return "Win32" ' Bd Win32 API.
            Case Else
                Return "Nieznany"
        End Select
    End Function

    ' Zwraca ostatnie 16 bitw kodu HRESULT (kod bdu).
    Function GetErrCode(ByVal hresult As Integer) As Integer
        Return hresult And &HFFFF
    End Function

    Private Sub cmdChangeCells_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdChangeCells.Click
        If Not SquareCells() Then _
            MsgBox("Operacja Excela nie powioda si.")
    End Sub

    Private Function SquareCells() As Boolean
        Try
            ' Prba wyczenia trybu interaktywnego.
            m_xl.Interactive = False
            ' Dla kadej komrki w wykorzystywanym zakresie aktywnego arkusza...
            For Each cel As Excel.Range In m_xl.ActiveSheet.UsedRange
                ' Podniesienie wartoci do kwadratu.
                cel.Value = cel.Value ^ 2
            Next
        Catch ex As System.Runtime.InteropServices.COMException
            ' Co si wydarzyo w Excelu.
            Debug.Fail(ex.Source & " " & Hex(ex.errorcode), ex.Message)
            Return False
        Catch ex As Exception
            ' Co si wydarzyo w rodowisku .NET (wywietlenie bdu podczas debugowania)
            Debug.Fail(ex.Source, ex.Message)
            Return False
        Finally
            Try
                ' Prba wczenia trybu interaktywnego.
                m_xl.Interactive = True
            Catch ex As Exception
                ' Nie ma potrzeby wykonywania adnych dziaa.
            End Try
        End Try
        ' Sukces.
        Return True
    End Function


    Function GetExcelVer() As String
        ' Definicja obiektw RegistryKey.
        Dim regRoot As RegistryKey, regExcel As RegistryKey, ver As String
        ' Pobranie korzenia rejestru.
        regRoot = Microsoft.Win32.Registry.ClassesRoot
        ' Pobranie z rejestru informacji o biecej wersji Excela.
        regExcel = regRoot.OpenSubKey("Excel.Application\CurVer")
        ' Jeli regExcel wynosi Nothing, Excela nie zainstalowano.
        If IsNothing(regExcel) Then
            ' Zamknicie klucza rejestru.
            regExcel.Close()
            ' Zwracenie 0, nie zainstalowano adnej wersji
            ver = "0"
        Else
            ver = regExcel.GetValue("")
        End If
        ' Zamknicie rejestru.
        regExcel.Close()
        ' Zwrcenie wersji Excela.
        Return ver
    End Function

End Class
