<?xml version="1.0" ?>
<!-- Worsheet.xslt przeksztalca arkusze XML na tabele HTML -->
<xsl:stylesheet version="1.0"
   xmlns="http://www.w3.org/"
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
   xmlns:o="urn:schemas-microsoft-com:office:office"
   xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">
	<xsl:output method="html" indent="yes" encoding="utf-8" />
	<xsl:template match="ss:Workbook">
		<html>
			<body>
			<h1>Wyswietlanie arkuszy XML w postaci tabel HTML</h1>
			Autor: <xsl:value-of select="o:DocumentProperties/o:Author" /><br />
			Ostatni zapis: <xsl:value-of select="o:DocumentProperties/o:LastSaved" /><br />
			Liczba arkuszy: <xsl:value-of select="count(ss:Worksheet)" />
			<xsl:for-each select="ss:Worksheet">
				<h2><xsl:value-of select="@ss:Name" /></h2>
				<table border="1" frame="box">
				<xsl:for-each select="ss:Table/ss:Row">
				<tr>
						<xsl:for-each select="ss:Cell/ss:Data">
							<td><xsl:value-of select="." /></td>
						</xsl:for-each>
				</tr>		
				</xsl:for-each>
				</table>
			</xsl:for-each>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>