<?xml version="1.0"?>
<!-- Strip.xslt transforms a XML Spreadsheet to its bare essentials -->
<xsl:stylesheet version="1.0" 
   xmlns="urn:schemas-microsoft-com:office:spreadsheet"
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
   xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">
    <xsl:output method="xml" indent="yes" />
    <xsl:template match="ss:Workbook">
    <xsl:processing-instruction name="mso-application">progid="Excel.Sheet"
    </xsl:processing-instruction>
    <xsl:element name="ss:Workbook">
        <xsl:copy-of select="ss:Styles" />
        <xsl:for-each select="ss:Worksheet">
            <xsl:if test="count(ss:Table/ss:Row/ss:Cell/ss:Data) &gt; 0">
                <xsl:copy-of select="." />
            </xsl:if>
        </xsl:for-each>
    </xsl:element>
    </xsl:template>
</xsl:stylesheet>
