<?xml version="1.0"?>
<!-- OrderToExcel.xslt transforms an Order XML file into an Excel XML Spreadsheet -->
<!--OrderToExcel.xslt transform an Order XML file into an Excel XML Spreadsheet-->
<xsl:stylesheet version="1.0"
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:o="urn:schemas-microsoft-com:office:office"
   xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
   xmlns="urn:schemas-microsoft-com:office:spreadsheet">
   <xsl:output encoding="utf-8"/>
<!--OrderToExcel.xslt transform an Order XML file into an Excel XML Spreadsheet--> <xsl:template match="/Orders">
    <xsl:processing-instruction name="mso-application">progid="Excel.Sheet"</xsl:processing-instruction>
    <xsl:element name="Workbook"
namespace="urn:schemas-microsoft-com:office:spreadsheet" >
    <xsl:call-template name="AddStyles" />
        <xsl:for-each select="Order">
            <!-- Create a worksheet for each order -->
            <xsl:element name="Worksheet">
                <!-- Name the worksheet -->
                <xsl:attribute name="ss:Name">
                    <xsl:value-of select="BillTo/Address/Name" />
                    <xsl:value-of select="ID" />
                </xsl:attribute>
                <xsl:element name="Table">
                <xsl:call-template name="AddColumns" />
                <!-- Add bill to headings -->
                <xsl:apply-templates select="BillTo" />
                <!-- Add send to headings -->
                <xsl:apply-templates select="ShipTo" />
                <!-- Add column headings -->
                <xsl:call-template name="AddColumnHeads" />
                    <xsl:for-each select="Line">
                        <xsl:apply-templates select="." />
                    </xsl:for-each>
                <xsl:call-template name="AddTotals" />
                </xsl:element>
            </xsl:element>
        </xsl:for-each>
    </xsl:element>
</xsl:template>


	<!-- Adds Styles node to Workbook. It's easier to use
	xsl:text here since these elements don't change based on
	the input XML -->
    <xsl:template name="AddStyles">
     <Styles xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">
      <Style ss:ID="ColHead">
        <Alignment ss:Horizontal="Center" ss:Vertical="Bottom"/>
       <Borders>
        <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>
       </Borders>
       <Font ss:Bold="1"/>
      </Style>
      <Style ss:ID="ItemHead">
        <Alignment ss:Horizontal="Right" ss:Vertical="Bottom"/>
       <Font ss:Bold="1"/>
      </Style>
      <Style ss:ID="Currency">
       <NumberFormat ss:Format="Currency"/>
      </Style>
     </Styles>
    </xsl:template>

	<!-- Sets column widths in Worksheet. It's easier to use
	xsl:text here since these elements don't change based on
	the input XML -->
	<xsl:template name="AddColumns">
	<Column ss:Width="70"/>
	<Column ss:Width="200"/>
	<Column ss:Width="50"/>
	<Column ss:Width="90"/>
	<Column ss:Width="50"/>
	<Column ss:Width="50"/>
	</xsl:template>
	
	<xsl:template match="BillTo">
		<xsl:element name="Row">
			<xsl:element name="Cell">
			<xsl:attribute name="ss:StyleID">ItemHead</xsl:attribute>
			<xsl:element name="Data">
					<xsl:attribute name="ss:Type">String</xsl:attribute>Rachunek dla</xsl:element>
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates select="Address" />
	</xsl:template>
	
	<xsl:template match="ShipTo">
		<xsl:element name="Row">
			<xsl:element name="Cell">
			<xsl:attribute name="ss:StyleID">ItemHead</xsl:attribute>
			<xsl:element name="Data">
					<xsl:attribute name="ss:Type">String</xsl:attribute>Wysylka do</xsl:element>
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates select="Address" />
	</xsl:template>
	
	<xsl:template match="Address">
		<xsl:element name="Row">
		<xsl:element name="Cell" />
		<xsl:element name="Cell">
			<xsl:element name="Data">
					<xsl:attribute name="ss:Type">String</xsl:attribute><xsl:value-of select="Name" /></xsl:element>
			</xsl:element>
		</xsl:element>
		<xsl:element name="Row">
			<xsl:element name="Cell" />
			<xsl:element name="Cell">
				<xsl:element name="Data">
					<xsl:attribute name="ss:Type">String</xsl:attribute><xsl:value-of select="Street1" /></xsl:element>
			</xsl:element>
		</xsl:element>
		<xsl:if test="./Address/Street2 != ''">
		<xsl:element name="Row">
			<xsl:element name="Cell" />
			<xsl:element name="Cell">
				<xsl:element name="Data">
					<xsl:attribute name="ss:Type">String</xsl:attribute><xsl:value-of select="Street2" /></xsl:element>
			</xsl:element>
		</xsl:element>
		</xsl:if>
		<xsl:element name="Row">
			<xsl:element name="Cell" />
			<xsl:element name="Cell">
				<xsl:element name="Data">
					<xsl:attribute name="ss:Type">String</xsl:attribute><xsl:value-of select="City" />, <xsl:value-of select="State" /><xsl:text>   </xsl:text><xsl:value-of select="Zip" /></xsl:element>
			</xsl:element>
		</xsl:element>
		<xsl:element name="Row" />
	</xsl:template>
	
	<xsl:template name="AddColumnHeads">
		<xsl:element name="Row">
			<xsl:element name="Cell">
				<xsl:attribute name="ss:StyleID">ColHead</xsl:attribute>
				<xsl:element name="Data">
					<xsl:attribute name="ss:Type">String</xsl:attribute>#</xsl:element>
			</xsl:element>
			<xsl:element name="Cell">
				<xsl:attribute name="ss:StyleID">ColHead</xsl:attribute>
				<xsl:element name="Data">
					<xsl:attribute name="ss:Type">String</xsl:attribute>Opis</xsl:element>
			</xsl:element>
			<xsl:element name="Cell">
				<xsl:attribute name="ss:StyleID">ColHead</xsl:attribute>
				<xsl:element name="Data">
                                        <xsl:attribute name="ss:Type">String</xsl:attribute>Ilosc</xsl:element>
			</xsl:element>
			<xsl:element name="Cell">
				<xsl:attribute name="ss:StyleID">ColHead</xsl:attribute>
				<xsl:element name="Data">
					<xsl:attribute name="ss:Type">String</xsl:attribute>Cena jednostkowa</xsl:element>
			</xsl:element>
			<xsl:element name="Cell">
				<xsl:attribute name="ss:StyleID">ColHead</xsl:attribute>
				<xsl:element name="Data">
					<xsl:attribute name="ss:Type">String</xsl:attribute>Razem</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	
	<!-- Add a row for each line item in the order -->
<xsl:template match="Line">
    <xsl:element name="Row">
        <xsl:element name="Cell">
            <xsl:element name="Data">
                <xsl:attribute name="ss:Type">Number</xsl:attribute>
                <xsl:value-of select="Number" />
            </xsl:element>
        </xsl:element>
        <xsl:element name="Cell">
            <xsl:element name="Data">
                <xsl:attribute name="ss:Type">String</xsl:attribute>
                <xsl:value-of select="Description" />
            </xsl:element>
        </xsl:element>
        <xsl:element name="Cell">
            <xsl:element name="Data">
                <xsl:attribute name="ss:Type">Number</xsl:attribute>
                <xsl:value-of select="Quantity" />
            </xsl:element>
        </xsl:element>
        <xsl:element name="Cell">
            <xsl:attribute name="ss:StyleID">Currency</xsl:attribute>
            <xsl:element name="Data">
                <xsl:attribute name="ss:Type">Number</xsl:attribute>
                <xsl:value-of select="UnitPrice" />
            </xsl:element>
        </xsl:element>
        <xsl:element name="Cell">
            <xsl:attribute name="ss:StyleID">Currency</xsl:attribute>
            <xsl:attribute name="ss:Formula">=RC[-2]*RC[-1]
              </xsl:attribute>
            <xsl:element name="Data">
                <xsl:attribute name="ss:Type">Number</xsl:attribute>
                <xsl:value-of select="Total" />
            </xsl:element>
        </xsl:element>
    </xsl:element>
</xsl:template>

	<xsl:template name="AddTotals">
			<xsl:element name="Row">
				<xsl:element name="Cell" />
				<xsl:element name="Cell" />
				<xsl:element name="Cell" />
				<xsl:element name="Cell">
					<xsl:attribute name="ss:StyleID">ItemHead</xsl:attribute>
					<xsl:element name="Data">
						<xsl:attribute name="ss:Type">String</xsl:attribute>Podsuma:</xsl:element>
				</xsl:element>
				<xsl:element name="Cell">
					<xsl:attribute name="ss:StyleID">Currency</xsl:attribute>
					<xsl:attribute name="ss:Formula">=SUM(R[-4]C:R[-1]C)</xsl:attribute>
					<xsl:element name="Data">
						<xsl:attribute name="ss:Type">Number</xsl:attribute>
						<xsl:value-of select="Total/Subtotal" />
					</xsl:element>
				</xsl:element>
			</xsl:element>
			<xsl:element name="Row">
				<xsl:element name="Cell" />
				<xsl:element name="Cell" />
				<xsl:element name="Cell" />
				<xsl:element name="Cell">
					<xsl:attribute name="ss:StyleID">ItemHead</xsl:attribute>
					<xsl:element name="Data">
						<xsl:attribute name="ss:Type">String</xsl:attribute>VAT:</xsl:element>
				</xsl:element>
				<xsl:element name="Cell">
					<xsl:attribute name="ss:StyleID">Currency</xsl:attribute>
					<xsl:element name="Data">
						<xsl:attribute name="ss:Type">Number</xsl:attribute>
						<xsl:value-of select="Total/Tax" />
					</xsl:element>
				</xsl:element>
			</xsl:element>
			<xsl:element name="Row">
				<xsl:element name="Cell" />
				<xsl:element name="Cell" />
				<xsl:element name="Cell" />
				<xsl:element name="Cell">
					<xsl:attribute name="ss:StyleID">ItemHead</xsl:attribute>
					<xsl:element name="Data">
						<xsl:attribute name="ss:Type">String</xsl:attribute>Razem:</xsl:element>
				</xsl:element>
				<xsl:element name="Cell">
					<xsl:attribute name="ss:StyleID">Currency</xsl:attribute>
					<xsl:attribute name="ss:Formula">=SUM(R[-2]C:R[-1]C)</xsl:attribute>
					<xsl:element name="Data">
						<xsl:attribute name="ss:Type">Number</xsl:attribute>
						<xsl:value-of select="Total/Due" />
					</xsl:element>
				</xsl:element>
			</xsl:element>
	</xsl:template>
	
</xsl:stylesheet>
