package com.titan.access;

import java.sql.*;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import javax.ejb.EJBException;

import com.titan.domain.*;

@Stateless
public class DataAccessBean implements DataAccess
{
   @PersistenceContext(unitName="titan") private EntityManager manager;
    
   @Resource(mappedName="java:/DefaultDS") DataSource dataSource;

   public List getCruises()
   {
      return manager.createQuery("FROM Cruise").getResultList();
   }

   public List getCabins(int cruiseId)
   {
      Ship ship = (Ship)manager.createQuery("SELECT cruise.ship FROM Cruise cruise WHERE cruise.id = " + cruiseId).getSingleResult();
      return manager.createQuery("FROM Cabin c WHERE c.ship = :ship").setParameter("ship", ship).getResultList();
   }

   public void initializeDB()
   {
      List list = manager.createQuery("FROM Ship ship").getResultList();
      if (list.size() > 0) 
      {
        return;
      }

      Customer bill = new Customer();
      bill.setFirstName("Bartosz");
      bill.setLastName("Biernacki");
      bill.setHasGoodCredit(true);

      Customer sacha = new Customer();
      sacha.setFirstName("Sebastian");
      sacha.setLastName("Libicki");
      sacha.setHasGoodCredit(false); // Sebastian ma kiepsk zdolno kredytow ;)

      Customer marc = new Customer();
      marc.setFirstName("Marcin");
      marc.setLastName("Florczak");
      marc.setHasGoodCredit(true);

      Customer monica = new Customer();
      monica.setFirstName("Monika");
      monica.setLastName("Biernacka");
      monica.setHasGoodCredit(true);

      Customer gavin = new Customer();
      gavin.setFirstName("Gerard");
      gavin.setLastName("Kikut");
      gavin.setHasGoodCredit(true);

      Customer rmh = new Customer();
      rmh.setFirstName("Ryszard");
      rmh.setLastName("Makowski");
      rmh.setHasGoodCredit(false);
      manager.persist(rmh);

      Address addr = new Address();
      addr.setStreet("ul. Biaostocka 123");
      addr.setCity("Bytom");
      addr.setState("lskie");
      addr.setZip("01-821");
      bill.setAddress(addr);
      Phone phone = new Phone();
      phone.setNumber("978-555-5555");
      bill.getPhoneNumbers().add(phone);
      phone = new Phone();
      phone.setNumber("617-555-5555");
      bill.getPhoneNumbers().add(phone);

      addr = new Address();
      addr.setStreet("al. Niepodlegoci 2");
      addr.setCity("Niepoomice");
      addr.setState("Maopolskie");
      addr.setZip("07-711");
      sacha.setAddress(addr);

      addr = new Address();
      addr.setStreet("pl. Gwny 4");
      addr.setState("Wrocaw");
      addr.setCity("Dolnolskie");
      addr.setZip("06-660");
      marc.setAddress(addr);

      addr = new Address();
      addr.setStreet("ul. Mieszka I");
      addr.setCity("Antonin");
      addr.setState("Wielkopolskie");
      addr.setZip("62-431");
      gavin.setAddress(addr);

      addr = new Address();
      addr.setStreet("ul. Bagienna 123");
      addr.setCity("Klony");
      addr.setState("Maopolskie");
      addr.setZip("12-660");
      monica.setAddress(addr);
      phone = new Phone();
      phone.setNumber("617-555-5555");
      monica.getPhoneNumbers().add(phone);

      CreditCompany capitalOne = new CreditCompany();
      capitalOne.setName("Capital One");
      addr = new Address();
      addr.setStreet("1 Federal Street");
      addr.setState("VA");
      addr.setCity("Richmond");
      addr.setZip("03032");
      capitalOne.setAddress(addr);
      manager.persist(capitalOne);

      CreditCompany mbna = new CreditCompany();
      mbna.setName("MBNA");
      addr = new Address();
      addr.setStreet("1 Federal Street");
      addr.setState("NC");
      addr.setCity("Charllote");
      addr.setZip("07732");
      mbna.setAddress(addr);
      manager.persist(mbna);

      CreditCard cc;
      cc = new CreditCard();
      cc.setExpirationDate(new Date());
      cc.setNumber("5324 9393 1010 2929");
      cc.setNameOnCard("Bartosz Biernacki");
      cc.setCreditCompany(capitalOne);
      bill.setCreditCard(cc);

      cc = new CreditCard();
      cc.setExpirationDate(new Date());
      cc.setNumber("3311 5000 1011 2333");
      cc.setNameOnCard("Sebastian Libicki");
      cc.setCreditCompany(capitalOne);
      sacha.setCreditCard(cc);

      cc = new CreditCard();
      cc.setNumber("4310 5131 7711 2663");
      cc.setNameOnCard("Marcin Florczak");
      cc.setCreditCompany(mbna);
      marc.setCreditCard(cc);

      cc = new CreditCard();
      cc.setNumber("4310 5144 7711 2663");
      cc.setNameOnCard("Monika Biernacka");
      cc.setCreditCompany(mbna);
      monica.setCreditCard(cc);

      cc = new CreditCard();
      cc.setNumber("5310 5144 7711 2663");
      cc.setNameOnCard("Gerard Kikut");
      cc.setCreditCompany(mbna);
      gavin.setCreditCard(cc);

      manager.persist(bill);
      manager.persist(sacha);
      manager.persist(marc);
      manager.persist(monica);
      manager.persist(gavin);

      Ship queenMary = new Ship("Queen Mary", 40000.0);
      manager.persist(queenMary);
      Ship titanic = new Ship("Titanic", 100000.0);
      manager.persist(titanic);
      
      // Tworzy kajuty
      Cabin cabin1 = new Cabin();
      cabin1.setDeckLevel(1);
      cabin1.setShip(queenMary);
      cabin1.setBedCount(1);
      cabin1.setName("Kajuta Krlowej 1");
      manager.persist(cabin1);

      Cabin cabin2 = new Cabin();
      cabin2.setDeckLevel(1);
      cabin2.setShip(queenMary);
      cabin2.setBedCount(1);
      cabin2.setName("Kajuta Krlowej 2");
      manager.persist(cabin2);
         
      Cabin cabin3 = new Cabin();
      cabin3.setDeckLevel(1);
      cabin3.setShip(titanic);
      cabin3.setBedCount(2);
      cabin3.setName("Kajuta Titanica 1");
      manager.persist(cabin3);
         
      Cabin cabin4 = new Cabin();
      cabin4.setDeckLevel(1);
      cabin4.setShip(titanic);
      cabin4.setBedCount(2);
      cabin4.setName("Kajuta Titanica 2");
      manager.persist(cabin4);
         
      Cabin cabin5 = new Cabin();
      cabin5.setDeckLevel(1);
      cabin5.setShip(titanic);
      cabin5.setBedCount(2);
      cabin5.setName("Kajuta Titanica 3");
      manager.persist(cabin5);

      // Tworzy rejsy
      Cruise alaskan = new Cruise("Rejs Alaskaski", queenMary);
      manager.persist(alaskan);
      Cruise atlantic = new Cruise("Rejs Atlantycki", titanic);
      manager.persist(atlantic);

   }
   // Tworzy rodowisko bazy danych
   //
   public void makePaymentDbTable()
   {
      PreparedStatement ps = null;
      Connection con = null;

      try
      {
         con = dataSource.getConnection();

         System.out.println("Tworzenie tabeli PAYMENT...");
         ps = con.prepareStatement("CREATE TABLE PAYMENT ( " +
                                   "CUSTOMER_ID INT, " +
                                   "AMOUNT DECIMAL (8,2), " +
                                   "TYPE CHAR (10), " +
                                   "CHECK_BAR_CODE CHAR (50), " +
                                   "CHECK_NUMBER INTEGER, " +
                                   "CREDIT_NUMBER CHAR (20), " +
                                   "CREDIT_EXP_DATE DATE" +
                                   ")");
         ps.execute();
         System.out.println("...gotowe!");
      }
      catch (SQLException sql)
      {
         throw new EJBException(sql);
      }
      finally
      {
         try { if (ps != null) ps.close(); } catch (Exception e) {}
         try { if (con != null) con.close(); } catch (Exception e) {}
      }
   }

   public void dropPaymentDbTable()
   {
      PreparedStatement ps = null;
      Connection con = null;

      try
      {
         con = dataSource.getConnection();

         System.out.println("Usuwanie tabeli PAYMENT...");
         ps = con.prepareStatement("DROP TABLE PAYMENT");
         ps.execute();
         System.out.println("...gotowe!");
      }
      catch (SQLException sql)
      {
         throw new EJBException(sql);
      }
      finally
      {
         try { if (ps != null) ps.close(); } catch (Exception e) {}
         try { if (con != null) con.close(); } catch (Exception e) {}
      }
   }
}
