package com.titan.clients;

import com.titan.access.*;
import com.titan.domain.*;

import javax.naming.InitialContext;
import javax.naming.Context;
import javax.naming.NamingException;

import javax.rmi.PortableRemoteObject;
import java.util.List;

public class Client 
{
    public static void main(String [] args) 
    {
        try 
	{
            Context jndiContext = getInitialContext();
            Object ref = jndiContext.lookup("DataAccessBean/remote");
            DataAccess dao = (DataAccess)ref;

            System.out.println("Odczytujemy encje rezerwacji z zainicjalizowanymi relacjami.");
            System.out.println();
            List list = dao.fetchReservationsWithRelationships();
            for (Object obj : list)
            {
               Reservation res = (Reservation)obj;
               System.out.println("Rezerwacja dla: " + res.getCruise().getName());
               System.out.println("\tLiczba kajut: " + res.getCabins().size());
               System.out.println("\tLiczba pasaerw: " + res.getCustomers().size());
            }
            System.out.println("----------");
            System.out.println("Prbujemy uzyska dostp do niezainicjalizowanych relacji.");
            System.out.println("----------");
            list = dao.fetchReservations();
            for (Object obj : list)
            {
               Reservation res = (Reservation)obj;
               System.out.println("Rezerwacja na: "
                       + res.getCruise().getName());
               try
               {
                  System.out.println("\tLiczba kajut: " + res.getCabins().size());
                  System.out.println("\tLiczba pasaerw: " + res.getCustomers().size());
               }
               catch (org.hibernate.LazyInitializationException
 
 ex)
               {
                  System.out.println(ex.getMessage());
               }
            }
        } 
        catch (javax.naming.NamingException ne)
        {
	    ne.printStackTrace();
	}
    }

    public static Context getInitialContext() 
        throws javax.naming.NamingException 
    {
        return new javax.naming.InitialContext();
    }
}
