package przyklady;

import java.util.*;
import javax.naming.Context;
import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.login.*;
import javax.security.auth.spi.*;

/**
 * Przykladowy modul logowania realizujacy uwierzytelnianie na podstawie hasla.
 *
 * Celem tej klasy jest bezposrednie przeprowadzenie procesu uwierzytelniania.
 */
public class ModulLogowaniaHaslem implements LoginModule {
 private Subject temat = null;

 /**
  * Inicjalizuje nas. Ustawiamy dla nas okreslony
  * temat, ktory pozniej uwierzytelnimy.
  */
 public void initialize(Subject temat,
                        CallbackHandler uchwytZwrotny,
                        Map wspolnyStan,
                        Map opcje) 
 {
  this.temat = temat;
 }

 /**
  * Ta metoda uwierzytelnia uzytkownika i jest wywolywana w
  * momencie, gdy klient probuje sie zalogowac.
  *
  * Implementacja naszej metody zawiera specyficzny dla producenta kontenera
  * sposob uzyskiwania dostepu do trwale zapisanych nazw uzytkownikow i ich hasel.
  *
  * Zauwaz, ze mimo, ze ten kod nie jest przenosny, jest w stu procentach
  * ukryty przed kodem aplikacji dzialajac w tle modulu logowania.
  * Naszym celem jest opracowanie roznych innych logowania dla kazdego
  * serwera J2EE.
  *
  * W tym przypadku, firma BEA udostepnila nam klase pomocnicza, ktora
  * komunikuje sie (za posrednictwem JNDI) z serweram Weblogic, ktory
  * nastepnie wykorzystuje aktualnie skonfigurowana w systemie usluge
  * bezpieczenstwa (jak zastosowanie pliku, RDBMS lub serwera LDAP).
  */
 public boolean login() throws LoginException 
 {
  try {
   /*
    * Uwierzytelnij uzytkownika na bazie otrzymanych referencji, wypelnij temat.
    *
    * Uwaga: W rzeczywistej aplikacji, nie kodowalibysmy na sztywno
    * nazwy uzytkownika i hasla. Zamiast tego, napisalibysmy modul
    * logowania wielokrotnego uzytku, ktory dzialalby dla dowolnej
    * nazwy uzytkownika i hasla. Nastepnie, napisalibysmy specjalny
    * uchwyt zwrotny, ktory odpowiadalby za komunikacje z uzytkownikiem,
    * zadajac od niego np. hasla. W takim przypadku, wywolalibysmy
    * ten uchwyt zwrotny wlasnie tutaj.
    */
   weblogic.jndi.Environment srod = new weblogic.jndi.Environment(System.getProperties());
   srod.setSecurityPrincipal("gosc");
   srod.setSecurityCredentials("gosc");
   
   weblogic.security.auth.Authenticate.authenticate(srod, temat);

   /*
    * Zwracamy informacje, ze wlasnie pomyslnie uwierzytelnilismy nasz temat
    */
   return true;
  }
  catch (Exception e) {
   throw new LoginException(e.toString());
  }
 }

 /**
  * Ta metoda jest wywolywana, jesli caly proces uwierzytelniania
  * zakonczyl sie pomyslnie (nawet, jesli ten konretny modul logowania
  * zawiodl). Moze sie tak zdarzyc, jasli mamy takze inne moduly
  * logowania zaangazowane w proces uwierzytelniania.
  *
  * Metoda umozliwia nam wykonanie dodatkowych operacji, ale
  * poniewaz nasz przyklad ma byc maksymalnie uproszczony,
  * nie umieszczamy w metodzie zadnych dodatkowych instrukcji.
  *
  * @return true jesli metoda zakonczy sie pomyslnie
  */
 public boolean commit() throws LoginException {
  return true;
 }

 /**
  * Ta metoda jest wywolywana, jesli caly proces uwierzytelniania
  * zawiodl (nawet, jasli ten konkretny modul logowania zakonczyl
  * swoja prace pomyslnie). Moze sie tak zdarzyc, jesli istnieja
  * inne moduly logowania zaangarzowane w proces uwierzytelniania.
  *
  * Metoda umozliwia nam wykonanie dodatkowych operacji, ale
  * poniewaz nasz przyklad ma byc maksymalnie uproszczony,
  * nie umieszczamy w metodzie zadnych dodatkowych instrukcji.
  *
  * @return true jesli metoda zakonczy sie pomyslnie
  */
 public boolean abort() throws LoginException {
  return true;
 }

 /**
  * Wylogowanie uzytkownika.
  *
  * @return true jesli metoda zakonczy sie pomyslnie
  */
 public boolean logout() throws LoginException {
  return true;
 }
}

