import javax.naming.*;

import javax.jms.*;
import java.util.*;

public class TematKlient {

 public static void main (String[] args) throws Exception {

  // Inicjalizuje JNDI
  Context kontekst = new InitialContext(System.getProperties());

  // 1: Wyszukaj ConnectionFactory (kreator polaczenia) za posrednictwem JNDI
  TopicConnectionFactory kreator = (TopicConnectionFactory) kontekst.lookup("javax.jms.TopicConnectionFactory");

  // 2: Wykorzystaj kreator polaczenia do stworzenia polaczenia JMS
  TopicConnection polaczenie = kreator.createTopicConnection();

  // 3: Wykorzystaj polaczenie do stworzenia sesji
  TopicSession sesja = polaczenie.createTopicSession(false, Session.AUTO_ACKNOWLEDGE); 

  // 4: Wyszukaj cel (temat) za pomoca JNDI
  Topic temat = (Topic)kontekst.lookup("temattestowy");

  // 5: Stworz producenta komunikatu 
  TopicPublisher wydawca = sesja.createPublisher(temat);

  // 6: Stworz i wydaj komunikat tekstowy
  TextMessage komunikat = sesja.createTextMessage();
  komunikat.setText("To jest komunikat testowy."); 
  wydawca.publish(komunikat);
 }
}

