package przyklady;

import javax.naming.Context;
import javax.naming.InitialContext;
import java.util.Properties;

/**
 * Klasa jest przykladem kodu klienta wywolujacego
 * metody prostego bezstanowego komponentu sesyjnego.
 */
public class WitajKlient {

  public static void main(String[] args) throws Exception {
    /*
     * Wlasciwosci inicjalizacji JNDI.
     *
     * Te wlasciwosci beda czytane z
     * linii polecen.
     */
    Properties wlasciwosci = System.getProperties();

    /*
     * Uzyskanie poczatkowego kontekstu JNDI.
     *
     * Kontekst poczatkowy jest jednoczesnie punktem poczatkowym
     * dla polaczenia z drzewem JNDI. Wybieramy nasz sterownik
     * JNDI, lokalizacje sieciowa serwera itp. przekazujac 
     * wlasnosci srodowiska.
     */
    Context kontekst = new InitialContext(wlasciwosci);

    /*
     * Pobieranie wskaznika do obiektu domowego, czyli posrednika 
     * w dostepie do obiektow EJB komponentu Witaj
     */
    Object obiekt = kontekst.lookup("WitajDomowy");


    /*
     * Obiekty domowe sa obiektami RMI-IIOP, musimy je wiec
     * rzutowac do obiektow RMI-IIOP za pomoca specjalnej
     * metody rzutujacej RMI-IIOP.
     *
     * Wiecej szczegolow na ten temat znajdziesz w dodatku A.
     */

    WitajDomowy domowy = (WitajDomowy) javax.rmi.PortableRemoteObject.narrow(obiekt, WitajDomowy.class);

    /*
     * Wykorzystujemy obiekt domowy do stworzenia obiektu EJB.
     */
    Witaj witaj = domowy.create();

    /*
     * Wywolujemy metode witaj() obiektu EJB. Obiekt EJB
     * przekaze wywolanie do komponentu, odbierze wynik
     * i zwroci go nam.
     *
     * Wydrukujemy wowczas ten wynik na ekranie.
     */
    System.out.println(witaj.witaj());

    /*
     * Obiekt EJB nie jest nam juz potrzebny, wiec usuwamy go.
     * Kontener wykona odpowiednie czynnosci, jesli wywolamy ponizsza metode.
     */
    witaj.remove();
  }
}
