package przyklady;

import javax.ejb.*;

/**
 * Demonstracja stanowego komponentu sesyjnego. Komponent jest inicjalizowany
 * z pewna wartoscia calkowitoliczbowa i zawiera metode biznesowa zwiekaszajaca
 * te wartosc.
 *
 * Przyklad prezentuje podstawy pisania stanowych komponentow sesyjnych
 * oraz dzialanie procesow pasywacji i aktywacji.
 */
public class LicznikKomponent implements SessionBean {
  
  // Aktualny stan licznika jest jednoczesnie stanem konwersacji.
  public int wartosc;

  //
  // Metody biznesowe
  //

  /**
   * Zliczanie
   */
  public int licz() {
    System.out.println("licz()");
    return ++wartosc;
  }

 //
 // Wymagane metody EJB
 //

 public void ejbCreate(int wartosc) throws CreateException {
   this.wartosc = wartosc;
   System.out.println("ejbCreate()");
 }

  public void ejbRemove() {
    System.out.println("ejbRemove()");
  }

  public void ejbActivate() {
    System.out.println("ejbActivate()");
  }

  public void ejbPassivate() {
    System.out.println("ejbPassivate()");
  }

  public void setSessionContext(SessionContext kontekst) {
  }
}
