package przyklady;

import javax.ejb.*;

/**
 * To jest lokalny interfejs naszego komponentu Konto.
 *
 * Z tym interfejsem pracuj lokalnie klienci,
 * ktrzy chc si dosta do lokalnego obiektu EJB.
 * Dostawca kontenera bedzie implementowal ten interfejs; 
 * zaimplementowany obiekt jest tym lokalnym obiektem EJB, 
 * ktory przekazuje wywolania do odpowiedniego komponentu.
*/
public interface KontoLokalny extends EJBLocalObject {

  /**
   * Wplaca dana kwote na konto.
   */
  public void wplac(double kwota) throws KontoException;
        
  /**
   * Wyplaca dana kwote z konta.
   * @throw KontoException, jesli kwota jest wieksza niz saldo
   */
  public void wyplac(double kwota) throws KontoException;

  // Metody zwracajace/ustawiajaca wartosci pol komponentu encyjnego

  public double getSaldo();

  public String getNazwiskoWlasciciela();
  public void setNazwiskoWlasciciela(String nazwisko);

  public String getKontoID();
  public void setKontoID(String identyfikator);
}
