package przyklady;

import javax.ejb.*;
import java.util.Collection;
import java.rmi.RemoteException;

/**
 * To jest interfejs domowy komponentu Konto. Interfejs
 * jest implementowany przez narzedzia serwera EJB - zas
 * zaimplementowany obiekt (nazywany obiektem domowym)
 * umozliwia klientom dostep do obiektow EJB.
 */
public interface KontoDomowy extends EJBHome {

  /**
   * Definiujemy w tym interfejsie domowym pojedyncza metode create(),
   * ktora odpowiada metodzie ejbCreate() klasy KontoKomponent.
   * Metoda tworzy lokalny obiekt EJB.
   *
   * Zauwaz, ze lokalny interfejs domowy zwraca interfejs lokalny,
   * w ktorym komponent zwraca klucz glowny.
   *
   * Zauwaz, ze nie generujemy wyjatkow RemoteException, poniewaz dzialamy lokalnie.
   *
   * @param identyfikatorKonta Unikalny numer konta
   * @param nazwiskoWlasciciela Nazwisko osoby posiadajacej to konto
   * @return Nowo stworzony obiekt lokalny.
   */
  Konto create(String identyfikatorKonta, String nazwiskoWlasciciela) throws CreateException, RemoteException;

  /**
   * Znajduje konto na podstawie jego klucza glownego (identyfikatora)
   */
  public Konto findByPrimaryKey(KontoKG klucz) throws FinderException, RemoteException;

  /**
   * Znajduje wszystkie konta posiadane przez dana osobe
   */
  public Collection findDlaNazwiskaWlasciciela(String nazwisko) throws FinderException, RemoteException;

  /**
   * To jest domowa metoda biznesowa niezalezna od danych konkretnego konta
   * Zwraca laczna ilosc srodkow na wszyskich kontach w naszym banku.
   */
  public double getLacznaWartoscKont() throws KontoException, RemoteException;

}

