package przyklady;

import java.util.Hashtable;
import javax.security.auth.login.*;

/**
 * Przykladowa klasa konfiguracji dla uwierzytelniania uzytkownika JAAS.
 * Klasa jest przydatna, poniewaz mozemy dokonywac w niej zmian, by umozliwic
 * wykorzystanie roznych modulow logowania bez koniecznosci ingerencji w kod
 * klienta.
 *
 * Przykladowo, moglibysmy miec modul logowania przeprowadzajacy uwierzytelniania
 * na podstawie nazw uzytkownika/hasla oraz inny, ktory bedzie przeprowadzal
 * uwierzytelnianie na podstawie certyfikatu z kluczem publicznym/prywatnym.
 */
public class HasloKonfiguracja extends Configuration {

 /**
  * Klasa konfiguracji musi zawierac bezargumentowy konstruktor
  */
 public HasloKonfiguracja() {}

 /**
  * Ta metoda wybiera wlasciwy modul logowania.
  */
 public AppConfigurationEntry[] getAppConfigurationEntry(String nazwaAplikacji) {
  /*
   * Zwraca jeden z napisanych przez nas modulow logowania, ktory wykorzystuje
   * mechanizm uwierzytelniania na bazie nazwy uzytkownika/hasla.
   *
   * - Flaga "REQUIRED" oznacza, ze wymagamy, by ten modul logowania
   *   pomyslnie zakonczyl uwierzytelnianie.
   * - Nowa tablica haszujaca bedzie zawierala opcje otrzymane przez
   *   modul logowania. Przykladowo, mozemy zdefiniowac opcje
   *   wlaczajaca tryb testowy aplikacji. Nasz modul logowania
   *   przeglada te tablice haszujaca i rozpoczyna proces logowania.
   */
  AppConfigurationEntry[] modulyLogowania = new AppConfigurationEntry[1];
  modulyLogowania[0] = new AppConfigurationEntry("przyklady.ModulLogowaniaHaslem", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new Hashtable());
  return modulyLogowania;
 }

 /**
  * Odswieza i przeladowuje obiekt konfiguracji ponownie odczytujac
  * wszystkie ustawienia logowania.
  */
 public void refresh() {}
}

