package przyklady;

import javax.ejb.*;
import java.rmi.RemoteException;

/**
 * To jest interfejs domowy komponentu Licznik. Interfejs
 * jest implementowany przez narzedzia serwera EJB - zas
 * zaimplementowany obiekt (nazywany obiektem domowym)
 * umozliwia klientom dostep do obiektow EJB.
 *
 * Jedyna metoda w tym interfejsie - create() - odpowiada
 * metodzie ejbCreate() w pliku LicznikKomponent.
*/
public interface LicznikDomowy extends EJBHome {

   /*
    * Metoda tworzy obiekt EJB.
    *
    * @param wartosc Wartosc inicjalizujaca licznik.
    *
    * @return Nowo tworzony obiekt EJB.
    */
  Licznik create(int wartosc) throws RemoteException, CreateException;
}
